/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.subsystems;

import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.SystemRemoteCommandMessage;
import org.eclipse.rse.subsystems.files.core.model.ISystemRemoteCommand;
import org.eclipse.rse.subsystems.files.core.model.ISystemRemoteCommandMessage;

public class SystemRemoteCommand
implements ISystemRemoteCommand {
    private String cmd = null;
    private String info = null;
    private Object object = null;
    private ISystemRemoteCommandMessage[] msgs = null;
    private ISubSystem subSys;

    public SystemRemoteCommand(String cmd, String[] msgsText) {
        this(cmd, msgsText, null, null);
    }

    public SystemRemoteCommand(String cmd, String[] msgsText, ISubSystem subSys) {
        this(cmd, msgsText, null, subSys);
    }

    public SystemRemoteCommand(String cmd, String[] msgsText, String[] msgsHelp) {
        this(cmd, msgsText, msgsHelp, null);
    }

    public SystemRemoteCommand(String cmd, String[] msgsText, String[] msgsHelp, ISubSystem subSys) {
        this.cmd = cmd;
        this.subSys = subSys;
        if (msgsText != null) {
            this.msgs = new SystemRemoteCommandMessage[msgsText.length];
            int i = 0;
            while (i < msgsText.length) {
                String msgHelp = null;
                if (msgsHelp != null && msgsHelp[i] != null) {
                    msgHelp = msgsHelp[i];
                }
                this.msgs[i] = new SystemRemoteCommandMessage(msgsText[i], msgHelp);
                ++i;
            }
        }
    }

    public SystemRemoteCommand(String cmd, ISystemRemoteCommandMessage[] msgs) {
        this(cmd, msgs, null);
    }

    public SystemRemoteCommand(String cmd, ISystemRemoteCommandMessage[] msgs, ISubSystem subSys) {
        this.cmd = cmd;
        this.msgs = msgs;
        this.subSys = subSys;
    }

    public String getCommand() {
        return this.cmd;
    }

    public String getInfo() {
        return this.info;
    }

    public Object getObject() {
        return this.object;
    }

    public ISubSystem getSubSystem() {
        return this.subSys;
    }

    public ISystemRemoteCommandMessage[] getMessages() {
        return this.msgs;
    }

    public void setSubSystem(ISubSystem sys) {
        this.subSys = sys;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(String.valueOf(this.cmd) + '\n');
        int j = 0;
        while (j < this.msgs.length) {
            text.append(String.valueOf(this.msgs[j].getMessageText()) + '\n');
            String msgHelp = this.msgs[j].getMessageHelp();
            if (msgHelp != null) {
                text.append(String.valueOf(msgHelp) + '\n');
            }
            ++j;
        }
        return text.toString();
    }
}

