/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICBreakpoint2;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.cdt.debug.core.model.ICBreakpointType;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class CBreakpoint
extends Breakpoint
implements ICBreakpoint2,
ICBreakpointType,
IDebugEventSetListener {
    private SortedMap<String, ICBreakpointExtension[]> fExtensions = new TreeMap<String, ICBreakpointExtension[]>();
    private int fInstallCount = 0;

    public CBreakpoint() {
    }

    public CBreakpoint(final IResource resource, final Map<String, Object> attributes, final boolean add) throws CoreException {
        this();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CBreakpoint.this.setMarker(resource.createMarker(CBreakpoint.this.getMarkerType()));
                CBreakpoint.this.ensureMarker().setAttributes(attributes);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public String getModelIdentifier() {
        return CDIDebugModel.getPluginIdentifier();
    }

    @Override
    public boolean isInstalled() throws CoreException {
        return this.fInstallCount > 0;
    }

    @Override
    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.condition", "");
    }

    @Override
    public void setCondition(String condition) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.condition", condition);
        this.setAttribute("message", this.getMarkerMessage());
    }

    @Override
    public int getIgnoreCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
    }

    @Override
    public void setIgnoreCount(int ignoreCount) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
        this.setAttribute("message", this.getMarkerMessage());
    }

    @Override
    public int getType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.breakpointType", 0);
    }

    @Override
    public void setType(int type) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.breakpointType", type);
        this.setAttribute("message", this.getMarkerMessage());
    }

    @Override
    public String getThreadId() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.threadId", null);
    }

    @Override
    public void setThreadId(String threadId) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.threadId", threadId);
    }

    @Override
    public String getSourceHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
    }

    @Override
    public void setSourceHandle(String sourceHandle) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
    }

    public void handleDebugEvents(DebugEvent[] events) {
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    protected abstract String getMarkerMessage() throws CoreException;

    @Override
    public synchronized int incrementInstallCount() throws CoreException {
        ++this.fInstallCount;
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", this.fInstallCount);
        return this.fInstallCount;
    }

    public int getInstallCount() throws CoreException {
        return this.fInstallCount;
    }

    @Override
    public synchronized int decrementInstallCount() throws CoreException {
        --this.fInstallCount;
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", this.fInstallCount);
        return this.fInstallCount;
    }

    @Override
    public synchronized void resetInstallCount() throws CoreException {
        if (this.fInstallCount != 0) {
            this.fInstallCount = 0;
            this.setAttribute("org.eclipse.cdt.debug.core.installCount", this.fInstallCount);
        }
    }

    @Override
    public boolean isConditional() throws CoreException {
        return this.getCondition() != null && this.getCondition().trim().length() > 0 || this.getIgnoreCount() > 0;
    }

    protected String getConditionText() throws CoreException {
        String condition;
        StringBuilder sb = new StringBuilder();
        int ignoreCount = this.getIgnoreCount();
        if (ignoreCount > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.1"), ignoreCount));
        }
        if ((condition = this.getCondition()) != null && condition.length() > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.2"), condition));
        }
        return sb.toString();
    }

    public void fireChanged() {
        if (this.markerExists()) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }

    @Override
    public String getModule() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.module", null);
    }

    @Override
    public void setModule(String module) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.module", module);
    }

    @Override
    public <V extends ICBreakpointExtension> V getExtension(String debugModelId, Class<V> extensionType) throws CoreException {
        ICBreakpointExtension[] extensions = this.getExtensionsForModelId(debugModelId);
        int i = 0;
        while (i < extensions.length) {
            if (extensionType.isAssignableFrom(extensions[i].getClass())) {
                ICBreakpointExtension retVal = extensions[i];
                return (V)retVal;
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 125, "Extension " + String.valueOf(extensionType) + " not defined for breakpoint " + String.valueOf(this), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICBreakpointExtension[] getExtensionsForModelId(String debugModelId) throws CoreException {
        if (!this.fExtensions.containsKey(debugModelId)) {
            SortedMap<String, ICBreakpointExtension[]> sortedMap = this.fExtensions;
            synchronized (sortedMap) {
                if (!this.fExtensions.containsKey(debugModelId)) {
                    IMarker marker = this.ensureMarker();
                    ArrayList<ICBreakpointExtension> extensions = new ArrayList<ICBreakpointExtension>(4);
                    IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(CDebugCorePlugin.getUniqueIdentifier(), "BreakpointExtension");
                    IConfigurationElement[] elements = ep.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i].getName().equals("breakpointExtension")) {
                            String elementDebugModelId = elements[i].getAttribute("debugModelId");
                            String elementMarkerType = elements[i].getAttribute("markerType");
                            if (elementDebugModelId == null) {
                                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 120, "Extension " + elements[i].getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: markerType", null));
                            } else if (elementMarkerType == null) {
                                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 120, "Extension " + elements[i].getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: debugModelId", null));
                            } else if (debugModelId.equals(elementDebugModelId) && marker.isSubtypeOf(elementMarkerType)) {
                                String className = elements[i].getAttribute("class");
                                if (className == null) {
                                    CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 120, "Extension " + elements[i].getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: className", null));
                                } else {
                                    try {
                                        ICBreakpointExtension extension = (ICBreakpointExtension)elements[i].createExecutableExtension("class");
                                        extension.initialize(this);
                                        extensions.add(extension);
                                    }
                                    catch (CoreException e) {
                                        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 120, "Extension " + elements[i].getDeclaringExtension().getUniqueIdentifier() + " contains an invalid value for attribute: className", (Throwable)e));
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    this.fExtensions.put(debugModelId, extensions.toArray(new ICBreakpointExtension[extensions.size()]));
                }
            }
        }
        return (ICBreakpointExtension[])this.fExtensions.get(debugModelId);
    }

    @Override
    public void refreshMessage() throws CoreException {
        IMarker marker = this.ensureMarker();
        marker.setAttribute("message", (Object)this.getMarkerMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExtensionMessage() {
        ArrayList<ICBreakpointExtension[]> extensionLists;
        SortedMap<String, ICBreakpointExtension[]> sortedMap = this.fExtensions;
        synchronized (sortedMap) {
            extensionLists = new ArrayList<ICBreakpointExtension[]>(this.fExtensions.values());
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = extensionLists.iterator();
        while (iterator.hasNext()) {
            ICBreakpointExtension[] extensions;
            ICBreakpointExtension[] iCBreakpointExtensionArray = extensions = (ICBreakpointExtension[])iterator.next();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                ICBreakpointExtension extension = iCBreakpointExtensionArray[n2];
                SafeRunner.run(() -> {
                    String message = extension.getExtensionMessage();
                    if (message != null && !message.isEmpty()) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(message);
                    }
                });
                ++n2;
            }
        }
        return sb.toString();
    }
}

