/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogRelationalRemoteDataSet;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWFactory;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.RelationalRemoteServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.RemoteServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWGenericNicknameImpl;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.util.TableToRemoteDataSetHelper;
import org.eclipse.datatools.enablement.ibm.util.ConnectionProfileUtility;
import org.eclipse.datatools.enablement.ibm.util.IRowCountCache;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogNickname
extends LUWGenericNicknameImpl
implements IRowCountCache,
ICatalogObject,
IDatabaseObject {
    private List remoteTableDependencyList = new LinkedList();
    private boolean columnsLoaded = false;
    private boolean serverLoaded = false;
    private boolean remoteDataSetLoaded = false;
    private boolean optionsLoaded = false;
    private boolean constraintLoaded = false;
    private boolean indexLoaded = false;
    private boolean remoteTableDependencyLoaded = false;
    private boolean batchLoad = false;
    private boolean privilegeLoaded = false;
    private boolean impactsLoaded = false;
    private boolean statisticsLoaded = false;
    private boolean rowCountLoaded = false;
    private boolean dependencyLoaded = false;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();
    private String rowCount = null;

    public void refresh() {
        this.columnsLoaded = false;
        this.constraintLoaded = false;
        this.serverLoaded = false;
        this.optionsLoaded = false;
        this.indexLoaded = false;
        this.remoteDataSetLoaded = false;
        this.remoteTableDependencyLoaded = false;
        this.remoteTableDependencyList.clear();
        this.privilegeLoaded = false;
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
            this.rowCountLoaded = false;
        }
    }

    public EList getColumns() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getColumns();
        }
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    @Override
    public LUWServer getServer() {
        if (!this.serverLoaded) {
            this.loadServer();
        }
        return this.server;
    }

    @Override
    public EList getOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getOptions();
        }
        if (!this.optionsLoaded) {
            this.loadOptions();
        }
        return super.getOptions();
    }

    public EList getConstraints() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getConstraints();
        }
        if (!this.constraintLoaded) {
            this.loadConstraints();
        }
        return this.constraints;
    }

    public EList getIndex() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getIndex();
        }
        if (!this.indexLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogTable.getStatistics(this.getConnection(), (Table)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 50) {
            this.getServer();
        } else if (id == 47) {
            this.getOptions();
        } else if (id == 3) {
            this.getDescription();
        } else if (id == 49) {
            this.getRemoteDataSet();
        } else if (id == 18) {
            this.getConstraints();
        } else if (id == 14) {
            this.getIndex();
        } else if (id == 7) {
            this.getPrivileges();
        } else if (id == 2) {
            this.getDependencies();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadColumns(this.getConnection(), super.getColumns(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.columnsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadOptions() {
        if (this.optionsLoaded) {
            return;
        }
        this.optionsLoaded = true;
        EList options = super.getOptions();
        options.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT OPTION, CAST(SUBSTR(SETTING, 1, 128) AS VARCHAR(128)) FROM SYSCAT.TABOPTIONS WHERE TABSCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(this.getName()) + "'";
            Statement s = this.getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String name = r.getString(1).trim();
                    String value = r.getString(2).trim();
                    LUWOption option = LUWFactory.eINSTANCE.createLUWOption();
                    option.setName(name);
                    if (value.length() == 255 && this.getCatalogDatabase().getVersion().equalsIgnoreCase("V8.2")) {
                        value = this.getOptionFromPackDescriptor(name);
                    }
                    option.setValue(value);
                    options.add((Object)option);
                }
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized String getOptionFromPackDescriptor(String option) {
        String value = new String("");
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            String stmtText = "{CALL SYSPROC.LIST_NN_LONG_OPTS(?,?,?,?)}";
            stmt = this.getConnection().prepareCall(stmtText);
            stmt.setString(1, this.getName());
            stmt.setString(2, this.getSchema().getName());
            stmt.setString(3, option);
            stmt.registerOutParameter(4, 4);
            stmt.execute();
            stmt.getInt(4);
            rs = stmt.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    value = rs.getString(1);
                }
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            try {
                if (rs != null) {
                    rs.close();
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return value;
    }

    private synchronized void loadServer() {
        if (this.serverLoaded) {
            return;
        }
        this.serverLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        block0: for (LUWOption option : this.getOptions()) {
            if (!option.getName().equals("SERVER")) continue;
            for (Object aServer : ((LUWCatalogDatabase)this.getCatalogDatabase()).getServers()) {
                LUWCatalogFederatedServer remoteServer;
                if (!(aServer instanceof LUWCatalogFederatedServer) || !(remoteServer = (LUWCatalogFederatedServer)aServer).getName().equals(option.getValue())) continue;
                this.setGenericServer(remoteServer);
                break block0;
            }
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadRemoteDataSet() {
        RemoteServer rs;
        if (this.remoteDataSetLoaded) {
            return;
        }
        this.remoteDataSetLoaded = true;
        LUWServer luwServer = this.getServer();
        if (luwServer != null && (rs = luwServer.getRemoteServer()) instanceof RelationalRemoteServer) {
            BaseTable remoteTable;
            String remoteSchemaName = null;
            String remoteTableName = null;
            RelationalRemoteServer relationalRS = (RelationalRemoteServer)rs;
            Database db = relationalRS.getDatabase();
            Iterator it = this.getOptions().iterator();
            while (it.hasNext() && (remoteSchemaName == null || remoteTableName == null)) {
                LUWOption option = (LUWOption)it.next();
                if (option.getName().equals("REMOTE_SCHEMA")) {
                    remoteSchemaName = option.getValue();
                    continue;
                }
                if (!option.getName().equals("REMOTE_TABLE")) continue;
                remoteTableName = option.getValue();
            }
            if (remoteSchemaName == null) {
                ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)luwServer.getWrapper().getLUWDatabase());
                IConnectionProfile profile = connectionInfo.getConnectionProfile();
                remoteSchemaName = ConnectionProfileUtility.getUID((IConnectionProfile)profile);
            }
            if (remoteSchemaName != null && remoteTableName != null && db != null && (remoteTable = LUWCatalogNickname.getRemoteTable(relationalRS.getDatabase(), remoteSchemaName, remoteTableName)) != null) {
                this.setRemoteDataSetFromTable(remoteTable);
            }
        }
    }

    public void setRemoteDataSetFromTable(BaseTable remoteTable) {
        LUWCatalogRelationalRemoteDataSet rds = (LUWCatalogRelationalRemoteDataSet)TableToRemoteDataSetHelper.getRemoteDataSet(remoteTable);
        if (rds == null) {
            rds = new LUWCatalogRelationalRemoteDataSet();
            rds.setName(this.getName());
            rds.setRemoteSchemaName(remoteTable.getSchema().getName());
            rds.setRemoteTableName(remoteTable.getName());
            rds.setTable(remoteTable);
            this.setRemoteDataSet(rds);
        }
        rds.getNickname().add((Object)this);
    }

    private synchronized void loadConstraints() {
        if (this.constraintLoaded) {
            return;
        }
        this.constraintLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadConstraints(this.getConnection(), super.getConstraints(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndexes() {
        if (this.indexLoaded) {
            return;
        }
        this.indexLoaded = true;
        EList indexes = super.getIndex();
        if (this.batchLoad) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadIndexes(this.getConnection(), indexes, (Table)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static Schema getRemoteSchema(Database database, String schemaName) {
        for (Schema s : database.getSchemas()) {
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        return null;
    }

    public static BaseTable getRemoteTable(Database database, String schemaName, String tableName) {
        Schema schema = LUWCatalogNickname.getRemoteSchema(database, schemaName);
        if (schema == null) {
            return null;
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return (BaseTable)table;
        }
        return null;
    }

    public List getRemoteTableDependencies() {
        if (!this.remoteTableDependencyLoaded) {
            this.loadRemoteTableDependencies();
        }
        return this.remoteTableDependencyList;
    }

    private synchronized void loadRemoteTableDependencies() {
        if (this.remoteTableDependencyLoaded) {
            return;
        }
        this.remoteTableDependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Database database = this.getSchema().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            LUWCatalogRelationalRemoteDataSet rrds = (LUWCatalogRelationalRemoteDataSet)this.getRemoteDataSet();
            if (rrds != null) {
                BaseTable obj = rrds.getTable();
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)obj);
                this.remoteTableDependencyList.add(dep);
            }
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, "");
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        EList dependencyList = super.getDependencies();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            if (this.getServer() != null) {
                Database database = this.getSchema().getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)this.getServer());
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected void setAsBatchLoad(boolean batchLoad) {
        this.batchLoad = batchLoad;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTable.getImpactedAlias(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTables(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTriggers(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedPackages(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedRoutines(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedConstraints(connection, (Table)this));
        return impacts;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    public String getRowCountString() {
        if (!this.rowCountLoaded) {
            this.rowCount = LUWCatalogTable.loadRowCount(this.getConnection(), (Table)this);
            this.rowCountLoaded = true;
        }
        return this.rowCount;
    }

    public void setRowCountString(String count) {
        this.rowCount = count;
        this.rowCountLoaded = true;
    }
}

