/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.ITableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataCell;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class TableDataEditorSelectionProvider
implements ISelectionProvider {
    protected ITableDataEditor editor;
    protected ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();

    public TableDataEditorSelectionProvider(ITableDataEditor editor) {
        this.editor = editor;
        this.registerSelectionListener();
    }

    protected void registerSelectionListener() {
        this.editor.getCursor().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDataEditorSelectionProvider.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableDataEditorSelectionProvider.this.selectionChanged();
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.editor.getCursor().getRow() == null) {
            return null;
        }
        return new StructuredSelection((Object)new TableDataCell(this.editor, this.editor.getCursor().getRow().getData(), this.editor.getCursor().getColumn()));
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged() {
        for (final ISelectionChangedListener listener : this.selectionChangedListeners) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TableDataEditorSelectionProvider.this, TableDataEditorSelectionProvider.this.getSelection()));
                }
            });
        }
    }
}

