/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.diagram;

import java.util.ArrayList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.filesystem.features.CreateInnerFileFeature;
import org.eclipse.graphiti.examples.filesystem.features.DeleteInnerFileFeature;
import org.eclipse.graphiti.examples.filesystem.features.GradientColorFeature;
import org.eclipse.graphiti.examples.mm.filesystem.Folder;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.graphiti.util.LocationInfo;

public class FilesystemToolBehaviorProvider
extends DefaultToolBehaviorProvider
implements IToolBehaviorProvider {
    public FilesystemToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    public ILocationInfo getLocationInfo(PictogramElement pe, ILocationInfo locationInfo) {
        Object domainObject = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (domainObject instanceof Folder && locationInfo != null) {
            return new LocationInfo((Shape)pe, locationInfo.getGraphicsAlgorithm());
        }
        return super.getLocationInfo(pe, locationInfo);
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        IContextMenuEntry[] ret = NO_CONTEXT_MENU_ENTRIES;
        ArrayList<ContextMenuEntry> retList = new ArrayList<ContextMenuEntry>();
        ICustomContext customContext = context;
        ICustomFeature[] customFeatures = this.getFeatureProvider().getCustomFeatures(customContext);
        ContextMenuEntry changeGradientColorEntry = null;
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            ContextMenuEntry contextMenuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            if (customFeature instanceof GradientColorFeature) {
                if (changeGradientColorEntry == null) {
                    changeGradientColorEntry = new ContextMenuEntry(null, null);
                    changeGradientColorEntry.setSubmenu(true);
                    changeGradientColorEntry.setText("Gradient Color");
                    changeGradientColorEntry.setDescription("Change Gradient Color");
                    retList.add(changeGradientColorEntry);
                }
                changeGradientColorEntry.add((IContextMenuEntry)contextMenuEntry);
            } else if (customFeature instanceof CreateInnerFileFeature) {
                retList.add(contextMenuEntry);
            } else if (customFeature instanceof DeleteInnerFileFeature) {
                retList.add(contextMenuEntry);
            }
            ++i;
        }
        return retList.toArray(ret);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        CustomContext customContext = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] customFeatures = this.getFeatureProvider().getCustomFeatures((ICustomContext)customContext);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature instanceof CreateInnerFileFeature) {
                button = null;
                button = new ContextButtonEntry((IFeature)customFeature, (IContext)customContext);
                button.setText(customFeature.getName());
                button.setDescription(customFeature.getDescription());
                button.setIconId("org.eclipse.graphiti.examples.filesystem.createFile");
                data.getDomainSpecificContextButtons().add(button);
            } else if (customFeature instanceof DeleteInnerFileFeature) {
                button = null;
                button = new ContextButtonEntry((IFeature)customFeature, (IContext)customContext);
                button.setText(customFeature.getName());
                button.setDescription(customFeature.getDescription());
                button.setIconId("org.eclipse.graphiti.examples.filesystem.deleteFile");
                data.getDomainSpecificContextButtons().add(button);
            }
            ++i;
        }
        return data;
    }
}

