/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexLoader;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;

class MultiPackIndexV1
implements MultiPackIndex {
    private final OidLookup idx;
    private final String[] packNames;
    private final byte[] bitmappedPackfiles;
    private final byte[] bitmapPackOrder;
    private final OffsetLookup offsets;
    private final MultiPackIndex.PackOffset result = new MultiPackIndex.PackOffset();

    MultiPackIndexV1(int hashLength, @NonNull byte[] oidFanout, @NonNull byte[] oidLookup, String[] packNames, byte[] bitmappedPackfiles, byte[] objectOffsets, byte[] largeObjectOffsets, byte[] bitmapPackOrder) throws MultiPackIndexLoader.MultiPackIndexFormatException {
        this.bitmappedPackfiles = bitmappedPackfiles;
        this.bitmapPackOrder = bitmapPackOrder;
        this.idx = new OidLookup(hashLength, oidFanout, oidLookup);
        this.offsets = new OffsetLookup(objectOffsets, largeObjectOffsets);
        this.packNames = packNames;
    }

    @Override
    public String[] getPackNames() {
        return this.packNames;
    }

    @Override
    public boolean hasObject(AnyObjectId oid) {
        return this.idx.findMultiPackIndexPosition(oid) != -1;
    }

    @Override
    public int findPosition(AnyObjectId oid) {
        return this.idx.findMultiPackIndexPosition(oid);
    }

    @Override
    public int getObjectCount() {
        return this.idx.getObjectCount();
    }

    @Override
    @Nullable
    public MultiPackIndex.PackOffset find(AnyObjectId objectId) {
        int position = this.idx.findMultiPackIndexPosition(objectId);
        if (position == -1) {
            return null;
        }
        this.offsets.getObjectOffset(position, this.result);
        return this.result;
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) {
        this.idx.resolve(matches, id, matchLimit);
    }

    @Override
    public long getMemorySize() {
        int packNamesSize = Arrays.stream(this.packNames).mapToInt(s -> s.getBytes(StandardCharsets.UTF_8).length).sum();
        return (long)(packNamesSize + MultiPackIndexV1.byteArrayLengh(this.bitmappedPackfiles) + MultiPackIndexV1.byteArrayLengh(this.bitmapPackOrder)) + this.idx.getMemorySize() + this.offsets.getMemorySize();
    }

    public String toString() {
        return "MultiPackIndexV1 {idx=" + String.valueOf(this.idx) + ", packfileNames=" + Arrays.toString(this.packNames) + ", bitmappedPackfiles=" + MultiPackIndexV1.byteArrayToString(this.bitmappedPackfiles) + ", objectOffsets=" + String.valueOf(this.offsets) + "}";
    }

    private static String byteArrayToString(byte[] array) {
        return array == null ? "null" : new String(array);
    }

    private static int byteArrayLengh(byte[] array) {
        return array == null ? 0 : array.length;
    }

    private static class OffsetLookup {
        private static final int OBJECT_OFFSETS_DATA_WIDTH = 8;
        private static final int BIT_31_ON = Integer.MIN_VALUE;
        private static final int TOGGLE_BIT_31 = Integer.MAX_VALUE;
        private final byte[] offsets;
        private final byte[] largeOffsets;

        OffsetLookup(@NonNull byte[] offsets, byte[] largeOffsets) {
            this.offsets = offsets;
            this.largeOffsets = largeOffsets;
        }

        void getObjectOffset(int position, MultiPackIndex.PackOffset result) {
            int offsetInChunk = position * 8;
            int packId = NB.decodeInt32(this.offsets, offsetInChunk);
            int offset = NB.decodeInt32(this.offsets, offsetInChunk + 4);
            if ((offset & Integer.MIN_VALUE) != 0) {
                long bigOffset;
                if (this.largeOffsets == null) {
                    bigOffset = NB.decodeUInt32(this.offsets, offsetInChunk + 4);
                } else {
                    int bigOffsetPos = offset & Integer.MAX_VALUE;
                    bigOffset = NB.decodeInt64(this.largeOffsets, bigOffsetPos * 8);
                }
                result.setValues(packId, bigOffset);
                return;
            }
            result.setValues(packId, offset);
        }

        long getMemorySize() {
            return (long)MultiPackIndexV1.byteArrayLengh(this.offsets) + (long)MultiPackIndexV1.byteArrayLengh(this.largeOffsets);
        }
    }

    private static class OidLookup {
        private static final int FANOUT = 256;
        private final int hashLength;
        private final int[] fanoutTable;
        private final byte[] oidLookup;

        OidLookup(int hashLength, @NonNull byte[] oidFanout, @NonNull byte[] oidLookup) throws MultiPackIndexLoader.MultiPackIndexFormatException {
            this.hashLength = hashLength;
            this.oidLookup = oidLookup;
            int[] table = new int[256];
            int k = 0;
            while (k < table.length) {
                long uint32 = NB.decodeUInt32(oidFanout, k * 4);
                if (uint32 > Integer.MAX_VALUE) {
                    throw new MultiPackIndexLoader.MultiPackIndexFormatException(JGitText.get().multiPackIndexFileIsTooLargeForJgit);
                }
                table[k] = (int)uint32;
                ++k;
            }
            this.fanoutTable = table;
        }

        int findMultiPackIndexPosition(AnyObjectId id) {
            int levelOne = id.getFirstByte();
            int high = this.fanoutTable[levelOne];
            int low = 0;
            if (levelOne > 0) {
                low = this.fanoutTable[levelOne - 1];
            }
            while (low < high) {
                int mid = low + high >>> 1;
                int cmp = id.compareTo(this.oidLookup, this.hashLength * mid);
                if (cmp < 0) {
                    high = mid;
                    continue;
                }
                if (cmp == 0) {
                    return mid;
                }
                low = mid + 1;
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) {
            if (matches.size() >= matchLimit) {
                return;
            }
            if (this.oidLookup.length == 0) {
                return;
            }
            levelOne = id.getFirstByte();
            high = this.fanoutTable[levelOne];
            low = 0;
            if (levelOne > 0) {
                low = this.fanoutTable[levelOne - 1];
            }
            p = -1;
            found = false;
            while (low < high) {
                p = low + high >>> 1;
                cmp = id.prefixCompare(this.oidLookup, this.idOffset(p));
                if (cmp < 0) {
                    high = p;
                    continue;
                }
                if (cmp == 0) {
                    found = true;
                    break;
                }
                low = p + 1;
            }
            if (found) ** GOTO lbl26
            return;
lbl-1000:
            // 1 sources

            {
                --p;
lbl26:
                // 2 sources

                ** while (p > 0 && id.prefixCompare((byte[])this.oidLookup, (int)this.idOffset((int)(p - 1))) == 0)
            }
lbl27:
            // 2 sources

            while (p < high && id.prefixCompare(this.oidLookup, this.idOffset(p)) == 0 && matches.size() < matchLimit) {
                matches.add(ObjectId.fromRaw(this.oidLookup, this.idOffset(p)));
                ++p;
            }
        }

        private int idOffset(int position) {
            return position * this.hashLength;
        }

        long getMemorySize() {
            return 4L + (long)MultiPackIndexV1.byteArrayLengh(this.oidLookup) + 1024L;
        }

        int getObjectCount() {
            return this.fanoutTable[255];
        }
    }
}

