/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.AlignmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructBodyParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.StructDeclarationFlattener;

public final class StructParser
extends AbstractScopedCommonTreeParser {
    public static final StructParser INSTANCE = new StructParser();

    private StructParser() {
    }

    @Override
    public StructDeclaration parse(ICTFMetadataNode struct, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        ICTFMetadataNode identifier = ((Param)param).fIdentifier;
        List<ICTFMetadataNode> children = struct.getChildren();
        StructDeclaration structDeclaration = null;
        String structName = null;
        boolean hasName = false;
        ICTFMetadataNode structBody = null;
        boolean hasBody = false;
        long structAlign = 0L;
        if (struct instanceof CTFAntlrMetadataNode) {
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[108].equals(type)) {
                    hasName = true;
                    ICTFMetadataNode structNameIdentifier = child.getChild(0);
                    structName = structNameIdentifier.getText();
                    continue;
                }
                if (CTFParser.tokenNames[107].equals(type)) {
                    hasBody = true;
                    structBody = child;
                    continue;
                }
                if (CTFParser.tokenNames[82].equals(type)) {
                    ICTFMetadataNode structAlignExpression = child.getChild(0);
                    structAlign = AlignmentParser.INSTANCE.parse(structAlignExpression, null);
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
            if (!hasName && identifier != null) {
                structName = identifier.getText();
                hasName = true;
            }
        } else {
            if (((JsonStructureFieldMetadataNode)struct).getMinimumAlignment() != 0) {
                structAlign = AlignmentParser.INSTANCE.parse(struct, null);
            }
            if (((JsonStructureFieldMetadataNode)struct).getMemberClasses() != null) {
                hasBody = true;
                structBody = struct;
            }
        }
        if (hasBody) {
            if (hasName && scope.lookupStruct(structName) != null) {
                throw new ParseException("struct " + structName + " already defined.");
            }
            structDeclaration = new StructDeclaration(structAlign);
            CTFTrace trace = ((Param)param).fTrace;
            StructBodyParser.INSTANCE.parse(structBody, new StructBodyParser.Param(structDeclaration, trace, structName, scope));
            if (hasName) {
                scope.registerStruct(structName, structDeclaration);
            }
        } else if (hasName) {
            structDeclaration = scope.lookupStructRecursive(structName);
            if (structDeclaration == null) {
                throw new ParseException("struct " + structName + " is not defined");
            }
        } else {
            throw new ParseException("struct with no name and no body");
        }
        return StructDeclarationFlattener.tryFlattenStruct(structDeclaration);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final @Nullable ICTFMetadataNode fIdentifier;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, @Nullable ICTFMetadataNode identifier, DeclarationScope scope) {
            this.fTrace = trace;
            this.fIdentifier = identifier;
            this.fDeclarationScope = scope;
        }
    }
}

