/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;

public final class GenericPropertyDescription
extends AbstractDescription {
    private final String m_id;
    private String m_title;
    private final Class<?> m_type;
    private PropertyCategory m_category = PropertyCategory.NORMAL;
    private final List<ExpressionAccessor> m_accessors = new ArrayList<ExpressionAccessor>();
    private Object m_defaultValue = Property.UNKNOWN_VALUE;
    private ExpressionConverter m_converter;
    private PropertyEditor m_editor;

    public GenericPropertyDescription(String id, String title) {
        this(id, title, null);
    }

    public GenericPropertyDescription(String id, String title, Class<?> type) {
        this.m_id = id;
        this.m_title = title;
        this.m_type = type;
    }

    public String getId() {
        return this.m_id;
    }

    public String getTitle() {
        String title = this.getTag("title");
        if (title != null) {
            return title;
        }
        return this.m_title;
    }

    public Class<?> getType() {
        return this.m_type;
    }

    public void setCategory(PropertyCategory category) {
        this.m_category = category;
    }

    public PropertyCategory getCategory() {
        return this.m_category;
    }

    public List<ExpressionAccessor> getAccessorsList() {
        return this.m_accessors;
    }

    public ExpressionAccessor[] getAccessorsArray() {
        return this.m_accessors.toArray(new ExpressionAccessor[this.m_accessors.size()]);
    }

    public void addAccessor(ExpressionAccessor accessor) {
        this.m_accessors.add(accessor);
        accessor.setPropertyDescription(this);
    }

    Method getSetter() {
        List<ExpressionAccessor> accessors = this.getAccessorsList();
        for (ExpressionAccessor accessor : accessors) {
            if (!(accessor instanceof SetterAccessor)) continue;
            return ((SetterAccessor)accessor).getSetter();
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public void setConverter(ExpressionConverter converter) {
        this.m_converter = converter;
    }

    public ExpressionConverter getConverter() {
        return this.m_converter;
    }

    public void setEditor(PropertyEditor editor) {
        this.m_editor = editor;
    }

    public PropertyEditor getEditor() {
        return this.m_editor;
    }

    public void join(GenericPropertyDescription property) {
        this.m_title = property.getTitle();
    }

    @Override
    public void visit(JavaInfo javaInfo, int state) throws Exception {
        super.visit(javaInfo, state);
        for (ExpressionAccessor accessor : this.m_accessors) {
            accessor.visit(javaInfo, state);
        }
    }
}

