/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui.common;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.edit.EditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.AbstractSourceNewComposite;
import org.eclipse.wb.internal.core.nls.ui.common.SourceClassParameters;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StatusUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.PackageRootAndPackageSelectionDialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class AbstractFieldsSourceNewComposite
extends AbstractSourceNewComposite {
    protected final JavaInfo m_root;
    protected final AstEditor m_editor;
    protected final ICompilationUnit m_compilationUnit;
    protected final IDialogFieldListener m_validateListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            AbstractFieldsSourceNewComposite.this.validateAll();
        }
    };
    private final Map<String, IStatus> m_statusMap = new TreeMap<String, IStatus>();
    private static int m_nextKeyId;

    public AbstractFieldsSourceNewComposite(Composite parent, int style, JavaInfo root) {
        super(parent, style);
        this.m_root = root;
        this.m_editor = this.m_root.getEditor();
        this.m_compilationUnit = this.m_editor.getModelUnit();
        GridLayoutFactory.create((Composite)this);
    }

    protected final void createTextFieldControls(Composite parent, StringDialogField field, int nColumns) {
        DialogFieldUtils.fillControls((Composite)parent, (DialogField)field, (int)nColumns, (int)60);
    }

    protected void validateAll() {
        this.firePropertyChanged("status", null, null);
    }

    protected final void setStatus(String key, IStatus status) {
        this.m_statusMap.put(key, status);
    }

    protected final void setInvalid(String key, String message) {
        this.setStatus(key, StatusUtils.createError((String)message));
    }

    protected final void setValid(String key) {
        this.setStatus(key, StatusUtils.OK_STATUS);
    }

    protected final String getUniqueKey() {
        return Integer.toString(m_nextKeyId++);
    }

    @Override
    public final IStatus getStatus() {
        return StatusUtils.getMostSevere(this.m_statusMap.values());
    }

    protected final IEditableSource createEmptyEditable(String name) {
        EditableSource editableSource = new EditableSource();
        String title = "NEW: " + name;
        editableSource.setShortTitle(title);
        editableSource.setLongTitle(title);
        editableSource.add(LocaleInfo.DEFAULT, new HashMap<String, String>());
        return editableSource;
    }

    protected class ClassSelectionGroup {
        private final PackageRootAndPackageSelectionDialogField m_packageField;
        private final StringButtonDialogField m_classField;
        private final String KEY_FOLDER;
        private final String KEY_PACKAGE;
        private final String KEY_CLASS;

        public ClassSelectionGroup(Composite parent, String groupTitle, final String selectPattern) {
            this.KEY_FOLDER = AbstractFieldsSourceNewComposite.this.getUniqueKey();
            this.KEY_PACKAGE = AbstractFieldsSourceNewComposite.this.getUniqueKey();
            this.KEY_CLASS = AbstractFieldsSourceNewComposite.this.getUniqueKey();
            Group classGroup = new Group(parent, 0);
            GridDataFactory.create((Control)classGroup).grabH().fillH();
            GridLayoutFactory.create((Composite)classGroup).columns(3);
            classGroup.setText(groupTitle);
            this.m_packageField = new PackageRootAndPackageSelectionDialogField(60, Messages.AbstractFieldsSourceNewComposite_sourceFolder, Messages.AbstractFieldsSourceNewComposite_sourceFolderBrowse, Messages.AbstractFieldsSourceNewComposite_package, Messages.AbstractFieldsSourceNewComposite_packageBrowse);
            this.m_packageField.setDialogFieldListener(AbstractFieldsSourceNewComposite.this.m_validateListener);
            this.m_packageField.doFillIntoGrid((Composite)classGroup, 3);
            this.m_classField = new StringButtonDialogField(new IStringButtonAdapter(){

                public void changeControlPressed(DialogField field) {
                    try {
                        IPackageFragmentRoot sourceFolder = ClassSelectionGroup.this.m_packageField.getRoot();
                        ProgressMonitorDialog context = new ProgressMonitorDialog(DesignerPlugin.getShell());
                        IJavaSearchScope scope = sourceFolder != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{sourceFolder}) : SearchEngine.createWorkspaceScope();
                        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)AbstractFieldsSourceNewComposite.this.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)6, (boolean)false, (String)selectPattern);
                        dialog.setTitle(Messages.AbstractFieldsSourceNewComposite_chooseTitle);
                        dialog.setMessage(Messages.AbstractFieldsSourceNewComposite_chooseMessage);
                        if (dialog.open() != 0) {
                            return;
                        }
                        IType type = (IType)dialog.getResult()[0];
                        ICompilationUnit compilationUnit = type.getCompilationUnit();
                        ClassSelectionGroup.this.m_packageField.setCompilationUnit(compilationUnit);
                        ClassSelectionGroup.this.m_classField.setText(type.getElementName());
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            });
            this.m_classField.setDialogFieldListener(AbstractFieldsSourceNewComposite.this.m_validateListener);
            this.m_classField.setLabelText(Messages.AbstractFieldsSourceNewComposite_chooseLabel);
            this.m_classField.setButtonLabel(Messages.AbstractFieldsSourceNewComposite_chooseBrowse);
            AbstractFieldsSourceNewComposite.this.createTextFieldControls((Composite)classGroup, (StringDialogField)this.m_classField, 3);
            this.createAdditionalFields((Composite)classGroup);
        }

        protected void createAdditionalFields(Composite parent) {
        }

        protected void setClassExists(boolean exists) {
        }

        public void validate() {
            IPackageFragmentRoot root = this.m_packageField.getRoot();
            if (root == null || !root.exists()) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_FOLDER, Messages.AbstractFieldsSourceNewComposite_validateSourceFolder);
            } else {
                AbstractFieldsSourceNewComposite.this.setValid(this.KEY_FOLDER);
            }
            String packageName = null;
            IPackageFragment pkg = this.m_packageField.getPackage();
            String string = packageName = pkg == null ? null : pkg.getElementName();
            if (pkg == null || !pkg.exists()) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_PACKAGE, Messages.AbstractFieldsSourceNewComposite_validatePackage);
            } else if (pkg.getElementName().length() == 0) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_PACKAGE, Messages.AbstractFieldsSourceNewComposite_validatePackageDefault);
            } else {
                AbstractFieldsSourceNewComposite.this.setValid(this.KEY_PACKAGE);
            }
            String className = this.m_classField.getText();
            IStatus status = JavaConventions.validateJavaTypeName((String)className);
            if (className.indexOf(46) != -1) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_CLASS, Messages.AbstractFieldsSourceNewComposite_validateClassDot);
            } else if (status.getSeverity() != 0) {
                AbstractFieldsSourceNewComposite.this.setStatus(this.KEY_CLASS, status);
            } else {
                AbstractFieldsSourceNewComposite.this.setValid(this.KEY_CLASS);
            }
            try {
                String fullClassName = packageName + "." + className;
                IType type = AbstractFieldsSourceNewComposite.this.m_editor.getJavaProject().findType(fullClassName);
                this.setClassExists(type == null);
            }
            catch (Throwable e) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_CLASS, "Exception: " + e.getMessage());
            }
        }

        public final void initialize(String initialClassName) {
            this.m_packageField.setCompilationUnit(AbstractFieldsSourceNewComposite.this.m_compilationUnit);
            this.m_classField.setText(initialClassName);
        }

        public final SourceClassParameters getParameters() throws Exception {
            SourceClassParameters parameters = new SourceClassParameters();
            parameters.m_sourceFolder = this.m_packageField.getRoot();
            parameters.m_package = this.m_packageField.getPackage();
            parameters.m_packageFolder = (IFolder)parameters.m_package.getUnderlyingResource();
            parameters.m_packageName = parameters.m_package.getElementName();
            parameters.m_className = this.m_classField.getText();
            parameters.m_fullClassName = parameters.m_packageName + "." + parameters.m_className;
            IJavaProject javaProject = AbstractFieldsSourceNewComposite.this.m_editor.getJavaProject();
            parameters.m_exists = javaProject.findType(parameters.m_fullClassName) != null;
            return parameters;
        }
    }

    protected final class FieldNameGroup {
        private final StringDialogField m_field;
        private final String KEY_FIELD_NAME;

        public FieldNameGroup(Composite parent, String groupTitle) {
            this.KEY_FIELD_NAME = AbstractFieldsSourceNewComposite.this.getUniqueKey();
            Group fieldGroup = new Group(parent, 0);
            GridDataFactory.create((Control)fieldGroup).grabH().fillH();
            GridLayoutFactory.create((Composite)fieldGroup).columns(2);
            fieldGroup.setText(groupTitle);
            this.m_field = new StringDialogField();
            this.m_field.setDialogFieldListener(AbstractFieldsSourceNewComposite.this.m_validateListener);
            this.m_field.setLabelText(Messages.AbstractFieldsSourceNewComposite_fieldName);
            AbstractFieldsSourceNewComposite.this.createTextFieldControls((Composite)fieldGroup, this.m_field, 2);
        }

        public void validate() {
            final String fieldName = this.m_field.getText();
            final boolean[] hasSuchName = new boolean[1];
            AbstractFieldsSourceNewComposite.this.m_editor.getAstUnit().accept(new ASTVisitor(){

                public void endVisit(SimpleName node) {
                    hasSuchName[0] = hasSuchName[0] | node.getIdentifier().equals(fieldName);
                }
            });
            if (hasSuchName[0]) {
                AbstractFieldsSourceNewComposite.this.setInvalid(this.KEY_FIELD_NAME, MessageFormat.format(Messages.AbstractFieldsSourceNewComposite_validateFieldNameUsed, fieldName));
                return;
            }
            IStatus status = JavaConventions.validateFieldName((String)fieldName);
            if (!status.isOK()) {
                AbstractFieldsSourceNewComposite.this.setStatus(this.KEY_FIELD_NAME, status);
                return;
            }
            AbstractFieldsSourceNewComposite.this.setValid(this.KEY_FIELD_NAME);
        }

        public void initialize(String initialFieldName) {
            this.m_field.setText(initialFieldName);
        }

        public String getName() {
            return this.m_field.getText();
        }
    }
}

