/*******************************************************************************
 * Copyright (c) 2010, 2014 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

/**
 * This is a specialized tool control used by the TrimBarLayout to modify the
 * layout mechanisms.
 */
/*
 * class is referenced by
 * org.eclipse.ui.ide.application/LegacyIDE_fragment.e4xmi
 */
public class LayoutModifierToolControl {
	@PostConstruct
	void createWidget(Composite parent, @SuppressWarnings("unused") MToolControl tc) {
		Composite comp = new Composite(parent, SWT.NONE) {
			@Override
			public Point computeSize(int wHint, int hHint, boolean flushCache) {
				return new Point(0, 0);
			}
		};
		comp.setSize(0, 0);
	}
}
