/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern.id;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class IdPatternHelper {
    public static String getId(PropertyContainer container) {
        EList properties = container.getProperties();
        for (Property property : properties) {
            if (!"org.eclipse.graphiti.pattern.id.id".equals(property.getKey())) continue;
            return property.getValue();
        }
        return null;
    }

    public static void setId(PropertyContainer container, String id) {
        Graphiti.getPeService().setPropertyValue(container, "org.eclipse.graphiti.pattern.id.id", id);
    }

    public static PropertyContainer findById(PictogramElement pictogramElement, String idToFind) {
        PropertyContainer propertyContainer;
        if (idToFind == null || idToFind.length() == 0) {
            return null;
        }
        String id = IdPatternHelper.getId((PropertyContainer)pictogramElement);
        if (idToFind.equals(id)) {
            return pictogramElement;
        }
        GraphicsAlgorithm graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm();
        id = IdPatternHelper.getId((PropertyContainer)graphicsAlgorithm);
        if (idToFind.equals(id)) {
            return graphicsAlgorithm;
        }
        if (pictogramElement instanceof ContainerShape) {
            EList children = ((ContainerShape)pictogramElement).getChildren();
            for (Shape shape : children) {
                PropertyContainer propertyContainer2 = IdPatternHelper.findById((PictogramElement)shape, idToFind);
                if (propertyContainer2 == null) continue;
                return propertyContainer2;
            }
        }
        if ((propertyContainer = IdPatternHelper.findByIdInGraphicsAlgorithmChildren(graphicsAlgorithm, idToFind)) != null) {
            return propertyContainer;
        }
        return null;
    }

    public static PropertyContainer findByIdInGraphicsAlgorithmChildren(GraphicsAlgorithm graphicsAlgorithm, String idToFind) {
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithmChild : graphicsAlgorithmChildren) {
            String id = IdPatternHelper.getId((PropertyContainer)graphicsAlgorithmChild);
            if (idToFind.equals(id)) {
                return graphicsAlgorithmChild;
            }
            PropertyContainer propertyContainer = IdPatternHelper.findByIdInGraphicsAlgorithmChildren(graphicsAlgorithmChild, idToFind);
            if (propertyContainer == null) continue;
            return propertyContainer;
        }
        return null;
    }
}

