/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public final class FieldReuseVariableSupport
extends FieldVariableSupport {
    public FieldReuseVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo, variable);
    }

    public String toString() {
        return "field-reused: " + this.getName();
    }

    @Override
    public void setName(String newName) throws Exception {
        this.splitUniqueField();
        this.m_javaInfo.getVariableSupport().setName(newName);
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        this.assertJavaInfoCreatedAt(target);
        if (this.isVisibleAtTarget(target)) {
            return this.getName();
        }
        this.splitUniqueField();
        return this.m_javaInfo.getVariableSupport().getReferenceExpression(target);
    }

    @Override
    public boolean canConvertFieldToLocal() {
        return false;
    }

    @Override
    public void convertFieldToLocal() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    protected boolean prefixThis() {
        return false;
    }

    @Override
    public void setType(String newTypeName) throws Exception {
        this.splitUniqueField();
        ((FieldUniqueVariableSupport)this.m_javaInfo.getVariableSupport()).setType(newTypeName);
    }

    private void splitUniqueField() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        VariableDeclaration oldDeclaration = this.m_declaration;
        FieldDeclaration oldField = (FieldDeclaration)oldDeclaration.getParent();
        String oldFieldName = this.getName();
        String newFieldName = editor.getUniqueVariableName(-1, oldFieldName, null);
        Object modifiers = "private ";
        if (AstNodeUtils.isStatic((BodyDeclaration)oldField)) {
            modifiers = (String)modifiers + "static ";
        }
        if (oldDeclaration.getName() == this.m_variable) {
            this.modifyName("__tmpField");
            String fieldSource = (String)modifiers + editor.getSource((ASTNode)oldField.getType()) + " " + oldFieldName + ";";
            editor.addFieldDeclaration(fieldSource, new BodyDeclarationTarget((BodyDeclaration)oldField, true));
            List<Expression> componentReferences = this.getComponentReferences();
            for (Expression reference : this.getReferences()) {
                if (componentReferences.contains(reference)) {
                    this.modifyVariableName(reference, newFieldName);
                    continue;
                }
                this.modifyVariableName(reference, oldFieldName);
            }
        } else {
            String fieldSource = (String)modifiers + editor.getSource((ASTNode)oldField.getType()) + " " + newFieldName + ";";
            editor.addFieldDeclaration(fieldSource, new BodyDeclarationTarget((BodyDeclaration)oldField, false));
            this.replaceComponentReferences(newFieldName);
        }
        this.m_javaInfo.setVariableSupport(new FieldUniqueVariableSupport(this.m_javaInfo, this.m_variable));
    }
}

