/****************************************************************************
 * Copyright (c) 2004 Composent, Inc. and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    Composent, Inc. - initial API and implementation
 *
 * SPDX-License-Identifier: EPL-2.0
 *****************************************************************************/
package org.eclipse.ecf.provider.comm;

import java.io.IOException;
import org.eclipse.ecf.core.identity.ID;

/**
 * Asynchronous connection
 * 
 */
public interface IAsynchConnection extends IConnection {
	/**
	 * Send data asynchronously. Implementing classes should not block on
	 * sending the given data and return immediately.
	 * 
	 * @param receiver
	 *            the ID of the intended receiver
	 * @param data
	 *            the data to send
	 * @throws IOException
	 *             thrown if data cannot be sent (e.g. disconnected)
	 */
	public void sendAsynch(ID receiver, byte[] data) throws IOException;
}