/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.internal.client.ClientProvider;
import org.eclipse.rap.rwt.internal.client.WebClientProvider;
import org.eclipse.rap.rwt.service.ISessionStore;

public class ClientSelector {
    public static final String SELECTED_CLIENT = String.valueOf(ClientSelector.class.getName()) + ".selected";
    private final List<ClientProvider> clients = new ArrayList<ClientProvider>();
    private boolean activated = false;

    public void addClientProvider(ClientProvider clientProvider) {
        this.checkNotActivated();
        this.clients.add(clientProvider);
    }

    public void selectClient(HttpServletRequest request, ISessionStore sessionStore) {
        ClientProvider provider = this.findClientProvider(request);
        sessionStore.setAttribute(SELECTED_CLIENT, provider.getClient());
    }

    public Client getSelectedClient(ISessionStore sessionStore) {
        return (Client)sessionStore.getAttribute(SELECTED_CLIENT);
    }

    public void activate() {
        this.checkNotActivated();
        this.clients.add(new WebClientProvider());
        this.activated = true;
    }

    private void checkNotActivated() {
        if (this.activated) {
            throw new IllegalStateException("ClientSelector already activated");
        }
    }

    private ClientProvider findClientProvider(HttpServletRequest request) {
        for (ClientProvider provider : this.clients) {
            if (!provider.accept(request)) continue;
            return provider;
        }
        throw new IllegalStateException("No client provider found for request");
    }
}

