/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.InputStream;
import org.eclipse.rap.rwt.internal.util.StreamUtil;
import org.eclipse.rap.rwt.resources.IResourceManager;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.graphics.ImageDataCache;
import org.eclipse.swt.internal.graphics.InternalImage;

public class ImageDataFactory {
    private final IResourceManager resourceManager;
    private final ImageDataCache imageDataCache;

    public ImageDataFactory(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.imageDataCache = new ImageDataCache();
    }

    public ImageData findImageData(InternalImage internalImage) {
        ImageData result = this.imageDataCache.getImageData(internalImage);
        if (result == null && (result = this.createImageData(internalImage)) != null) {
            this.imageDataCache.putImageData(internalImage, result);
        }
        return result;
    }

    private ImageData createImageData(InternalImage internalImage) {
        ImageData result = null;
        String imagePath = internalImage.getResourceName();
        InputStream inputStream = this.resourceManager.getRegisteredContent(imagePath);
        if (inputStream != null) {
            try {
                result = new ImageData(inputStream);
            }
            finally {
                StreamUtil.close(inputStream);
            }
        }
        return result;
    }
}

