/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.application.ApplicationContextActivator;
import org.eclipse.rap.rwt.internal.application.ApplicationContextConfigurator;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rap.rwt.internal.resources.JSLibraryConcatenator;
import org.eclipse.rap.rwt.internal.resources.ResourceDirectory;
import org.eclipse.rap.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rap.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rap.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rap.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rap.rwt.internal.service.ServiceManager;
import org.eclipse.rap.rwt.internal.service.SettingStoreManager;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.textsize.ProbeStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorage;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.resources.IResourceManager;
import org.eclipse.rap.rwt.service.IApplicationStore;
import org.eclipse.swt.internal.graphics.FontDataFactory;
import org.eclipse.swt.internal.graphics.ImageDataFactory;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.DisplaysHolder;

public class ApplicationContext {
    public static IResourceManager testResourceManager;
    private ThemeManager themeManager;
    private final ResourceDirectory resourceDirectory;
    private final ResourceManagerImpl resourceManager;
    private final PhaseListenerRegistry phaseListenerRegistry;
    private final LifeCycleFactory lifeCycleFactory;
    private final EntryPointManager entryPointManager;
    private final LifeCycleAdapterFactory lifeCycleAdapterFactory;
    private final SettingStoreManager settingStoreManager;
    private final ServiceManager serviceManager;
    private final ResourceRegistry resourceRegistry;
    private final JSLibraryConcatenator jsLibraryConcatenator;
    private final ApplicationStoreImpl applicationStore = new ApplicationStoreImpl();
    private final ResourceFactory resourceFactory;
    private final ImageFactory imageFactory;
    private final InternalImageFactory internalImageFactory;
    private final ImageDataFactory imageDataFactory;
    private final FontDataFactory fontDataFactory;
    private final StartupPage startupPage;
    private final DisplaysHolder displaysHolder;
    private final TextSizeStorage textSizeStorage;
    private final ProbeStore probeStore;
    private final ServletContext servletContext;
    private final ApplicationContextConfigurator contextConfigurator;
    private final ApplicationContextActivator contextActivator;
    private final ClientSelector clientSelector;
    private boolean active;

    public ApplicationContext(ApplicationConfiguration applicationConfiguration, ServletContext servletContext) {
        this.resourceDirectory = new ResourceDirectory();
        this.resourceManager = new ResourceManagerImpl(this.resourceDirectory);
        this.phaseListenerRegistry = new PhaseListenerRegistry();
        this.entryPointManager = new EntryPointManager();
        this.lifeCycleFactory = new LifeCycleFactory(this);
        this.themeManager = new ThemeManager();
        this.resourceFactory = new ResourceFactory();
        this.imageFactory = new ImageFactory();
        this.internalImageFactory = new InternalImageFactory();
        this.imageDataFactory = new ImageDataFactory(this.resourceManager);
        this.fontDataFactory = new FontDataFactory();
        this.lifeCycleAdapterFactory = new LifeCycleAdapterFactory();
        this.settingStoreManager = new SettingStoreManager();
        this.resourceRegistry = new ResourceRegistry(this.getResourceManager());
        this.startupPage = new StartupPage(this);
        this.serviceManager = this.createServiceManager();
        this.displaysHolder = new DisplaysHolder();
        this.jsLibraryConcatenator = new JSLibraryConcatenator(this.resourceManager);
        this.textSizeStorage = new TextSizeStorage();
        this.probeStore = new ProbeStore(this.textSizeStorage);
        this.contextConfigurator = new ApplicationContextConfigurator(applicationConfiguration, servletContext);
        this.contextActivator = new ApplicationContextActivator(this);
        this.clientSelector = new ClientSelector();
        this.servletContext = servletContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.checkIsActivated();
        this.active = true;
        try {
            this.doActivate();
        }
        catch (RuntimeException rte) {
            this.active = false;
            throw rte;
        }
    }

    public void deactivate() {
        this.checkIsNotActivated();
        try {
            this.doDeactivate();
        }
        finally {
            this.active = false;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ResourceDirectory getResourceDirectory() {
        return this.resourceDirectory;
    }

    public IResourceManager getResourceManager() {
        return testResourceManager != null ? testResourceManager : this.resourceManager;
    }

    public EntryPointManager getEntryPointManager() {
        return this.entryPointManager;
    }

    public SettingStoreManager getSettingStoreManager() {
        return this.settingStoreManager;
    }

    public PhaseListenerRegistry getPhaseListenerRegistry() {
        return this.phaseListenerRegistry;
    }

    public LifeCycleAdapterFactory getLifeCycleAdapterFactory() {
        return this.lifeCycleAdapterFactory;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public JSLibraryConcatenator getJSLibraryConcatenator() {
        return this.jsLibraryConcatenator;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public LifeCycleFactory getLifeCycleFactory() {
        return this.lifeCycleFactory;
    }

    public IApplicationStore getApplicationStore() {
        return this.applicationStore;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public InternalImageFactory getInternalImageFactory() {
        return this.internalImageFactory;
    }

    public ImageDataFactory getImageDataFactory() {
        return this.imageDataFactory;
    }

    public FontDataFactory getFontDataFactory() {
        return this.fontDataFactory;
    }

    public StartupPage getStartupPage() {
        return this.startupPage;
    }

    public DisplaysHolder getDisplaysHolder() {
        return this.displaysHolder;
    }

    public TextSizeStorage getTextSizeStorage() {
        return this.textSizeStorage;
    }

    public ProbeStore getProbeStore() {
        return this.probeStore;
    }

    public ClientSelector getClientSelector() {
        return this.clientSelector;
    }

    private void checkIsNotActivated() {
        if (!this.active) {
            throw new IllegalStateException("The ApplicationContext has not been activated.");
        }
    }

    private void checkIsActivated() {
        if (this.active) {
            throw new IllegalStateException("The ApplicationContext has already been activated.");
        }
    }

    private void doActivate() {
        this.contextConfigurator.configure(this);
        this.contextActivator.activate();
    }

    private void doDeactivate() {
        this.contextActivator.deactivate();
        this.contextConfigurator.reset(this);
    }

    private ServiceManager createServiceManager() {
        return new ServiceManager(new LifeCycleServiceHandler(this.lifeCycleFactory, this.startupPage));
    }
}

