/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.IEntryPoint;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.swt.widgets.Display;

final class PrepareUIRoot
implements IPhase {
    private final ApplicationContext applicationContext;

    public PrepareUIRoot(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PhaseId getPhaseId() {
        return PhaseId.PREPARE_UI_ROOT;
    }

    public PhaseId execute(Display display) {
        PhaseId result;
        if (LifeCycleUtil.isStartup()) {
            IEntryPoint entryPoint = this.createEntryPoint();
            entryPoint.createUI();
            result = PhaseId.RENDER;
        } else {
            result = PhaseId.READ_DATA;
        }
        return result;
    }

    private IEntryPoint createEntryPoint() {
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        HttpServletRequest request = ContextProvider.getRequest();
        EntryPointRegistration registration = entryPointManager.getEntryPointRegistration(request);
        return registration.getFactory().create();
    }
}

