/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.RequestId;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.SessionStoreBuilder;
import org.eclipse.rap.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.theme.JsonValue;
import org.eclipse.rap.rwt.service.IServiceHandler;
import org.eclipse.rap.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
implements IServiceHandler {
    private static final String PROP_ERROR = "error";
    private static final String PROP_MESSAGE = "message";
    private static final String SESSION_STARTED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionStarted";
    private final LifeCycleFactory lifeCycleFactory;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(LifeCycleFactory lifeCycleFactory, StartupPage startupPage) {
        this.lifeCycleFactory = lifeCycleFactory;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException {
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSessionStore();
        Object object = sessionStore.getRequestLock();
        synchronized (object) {
            this.synchronizedService();
        }
    }

    void synchronizedService() throws IOException {
        if ("POST".equals(ContextProvider.getRequest().getMethod())) {
            try {
                this.handlePostRequest();
            }
            finally {
                LifeCycleServiceHandler.markSessionStarted();
            }
        } else {
            this.handleGetRequest();
        }
    }

    private void handleGetRequest() throws IOException {
        Map parameters = ContextProvider.getRequest().getParameterMap();
        RequestParameterBuffer.store(parameters);
        HttpServletResponse response = ContextProvider.getResponse();
        if (RWT.getClient() instanceof WebClient) {
            this.startupPage.send(response);
        } else {
            StartupJson.send(response);
        }
    }

    private void handlePostRequest() throws IOException {
        LifeCycleServiceHandler.setJsonResponseHeaders();
        if (LifeCycleServiceHandler.isSessionTimeout()) {
            LifeCycleServiceHandler.handleSessionTimeout();
        } else if (!LifeCycleServiceHandler.isRequestCounterValid()) {
            LifeCycleServiceHandler.handleInvalidRequestCounter();
        } else {
            if (LifeCycleServiceHandler.isSessionRestart()) {
                LifeCycleServiceHandler.reinitializeSessionStore();
                LifeCycleServiceHandler.reinitializeServiceStore();
            }
            RequestParameterBuffer.merge();
            this.runLifeCycle();
        }
        LifeCycleServiceHandler.writeProtocolMessage();
    }

    private void runLifeCycle() throws IOException {
        LifeCycle lifeCycle = (LifeCycle)this.lifeCycleFactory.getLifeCycle();
        lifeCycle.execute();
    }

    private static boolean isRequestCounterValid() {
        return LifeCycleServiceHandler.hasInitializeParameter() || RequestId.getInstance().isValid();
    }

    private static void handleInvalidRequestCounter() {
        int statusCode = 412;
        String errorType = "invalid request counter";
        String errorMessage = RWTMessages.getMessage("RWT_MultipleInstancesErrorMessage");
        LifeCycleServiceHandler.renderError(statusCode, errorType, LifeCycleServiceHandler.formatMessage(errorMessage));
    }

    private static void handleSessionTimeout() {
        int statusCode = 403;
        String errorType = "session timeout";
        String errorMessage = RWTMessages.getMessage("RWT_SessionTimeoutErrorMessage");
        LifeCycleServiceHandler.renderError(statusCode, errorType, LifeCycleServiceHandler.formatMessage(errorMessage));
    }

    private static String formatMessage(String message) {
        Object[] arguments = new Object[]{"<a {HREF_URL}>", "</a>"};
        return MessageFormat.format(message, arguments);
    }

    private static void renderError(int statusCode, String errorType, String errorMessage) {
        ContextProvider.getResponse().setStatus(statusCode);
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        writer.appendHead(PROP_ERROR, JsonValue.valueOf(errorType));
        writer.appendHead(PROP_MESSAGE, JsonValue.valueOf(errorMessage));
    }

    private static void reinitializeSessionStore() {
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSessionStore();
        Map<String, String[]> bufferedParameters = RequestParameterBuffer.getBufferedParameters();
        ApplicationContext applicationContext = ApplicationContextUtil.get(sessionStore);
        sessionStore.valueUnbound(null);
        HttpServletRequest request = ContextProvider.getRequest();
        SessionStoreBuilder builder = new SessionStoreBuilder(applicationContext, request);
        sessionStore = (SessionStoreImpl)builder.buildSessionStore();
        ContextProvider.getContext().setSessionStore(sessionStore);
        if (bufferedParameters != null) {
            RequestParameterBuffer.store(bufferedParameters);
        }
    }

    private static void reinitializeServiceStore() {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        ServiceStore serviceStore = (ServiceStore)ContextProvider.getServiceStore();
        serviceStore.clear();
        ProtocolUtil.setClientMessage(clientMessage);
    }

    private static boolean isSessionRestart() {
        return LifeCycleServiceHandler.isSessionStarted() && LifeCycleServiceHandler.hasInitializeParameter();
    }

    private static boolean isSessionTimeout() {
        return !LifeCycleServiceHandler.isSessionStarted() && !LifeCycleServiceHandler.hasInitializeParameter();
    }

    static void markSessionStarted() {
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        sessionStore.setAttribute(SESSION_STARTED, Boolean.TRUE);
    }

    private static boolean isSessionStarted() {
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        return Boolean.TRUE.equals(sessionStore.getAttribute(SESSION_STARTED));
    }

    private static boolean hasInitializeParameter() {
        return "true".equals(ProtocolUtil.readHeadPropertyValue("rwt_initialize"));
    }

    private static void setJsonResponseHeaders() {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private static void writeProtocolMessage() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        String message = protocolWriter.createMessage();
        response.getWriter().write(message);
    }
}

