/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabfolderkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public final class CTabFolderLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.CTabFolder";
    private static final String[] ALLOWED_STYLES = new String[]{"CLOSE", "FLAT", "SINGLE", "MULTI", "NO_RADIO_GROUP", "BORDER"};
    public static final String PARAM_SELECTION = "selection";
    public static final String PARAM_MAXIMIZED = "maximized";
    public static final String PARAM_MINIMIZED = "minimized";
    private static final String PROP_TOOLTIP_TEXTS = "toolTipTexts";
    private static final String PROP_TAB_POSITION = "tabPosition";
    private static final String PROP_TAB_HEIGHT = "tabHeight";
    private static final String PROP_MIN_MAX_STATE = "minMaxState";
    private static final String PROP_MINIMIZE_BOUNDS = "minimizeBounds";
    private static final String PROP_MINIMIZE_VISIBLE = "minimizeVisible";
    private static final String PROP_MAXIMIZE_BOUNDS = "maximizeBounds";
    private static final String PROP_MAXIMIZE_VISIBLE = "maximizeVisible";
    private static final String PROP_CHEVRON_BOUNDS = "chevronBounds";
    private static final String PROP_CHEVRON_VISIBLE = "chevronVisible";
    private static final String PROP_UNSELECTED_CLOSE_VISIBLE = "unselectedCloseVisible";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_BACKGROUND = "selectionBackground";
    private static final String PROP_SELECTION_FOREGROUND = "selectionForeground";
    private static final String PROP_SELECTION_BACKGROUND_IMAGE = "selectionBackgroundImage";
    private static final String PROP_SELECTION_BG_GRADIENT = "selectionBackgroundGradient";
    private static final String PROP_SELECTION_BG_GRADIENT_COLORS = "selectionBgGradientColors";
    private static final String PROP_SELECTION_BG_GRADIENT_PERCENTS = "selectionBgGradientPercents";
    private static final String PROP_SELECTION_BG_GRADIENT_VERTICAL = "selectionBgGradientVertical";
    private static final String PROP_BORDER_VISIBLE = "borderVisible";
    private static final String PROP_FOLDER_LISTENER = "Folder";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final String DEFAULT_TAB_POSITION = "top";
    private static final int DEFAULT_TAB_HEIGHT = 0;
    private static final String DEFAULT_MIN_MAX_STATE = "normal";
    private static final Rectangle ZERO_BOUNDS = new Rectangle(0, 0, 0, 0);

    public void preserveValues(Widget widget) {
        CTabFolder folder = (CTabFolder)widget;
        ControlLCAUtil.preserveValues(folder);
        WidgetLCAUtil.preserveCustomVariant(folder);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_TAB_POSITION, CTabFolderLCA.getTabPosition(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_TAB_HEIGHT, folder.getTabHeight());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MIN_MAX_STATE, CTabFolderLCA.getMinMaxState(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MINIMIZE_BOUNDS, CTabFolderLCA.getMinimizeBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MINIMIZE_VISIBLE, folder.getMinimizeVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MAXIMIZE_BOUNDS, CTabFolderLCA.getMaximizeBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MAXIMIZE_VISIBLE, folder.getMaximizeVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_CHEVRON_BOUNDS, CTabFolderLCA.getChevronBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_CHEVRON_VISIBLE, CTabFolderLCA.getChevronVisible(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_UNSELECTED_CLOSE_VISIBLE, folder.getUnselectedCloseVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, "selection", folder.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BACKGROUND, CTabFolderLCA.getSelectionBackground(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_FOREGROUND, CTabFolderLCA.getSelectionForeground(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BACKGROUND_IMAGE, CTabFolderLCA.getSelectionBackgroundImage(folder));
        CTabFolderLCA.preserveSelectionBgGradient(folder);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_BORDER_VISIBLE, folder.getBorderVisible());
        WidgetLCAUtil.preserveListener(folder, PROP_SELECTION_LISTENER, folder.isListening(13));
        WidgetLCAUtil.preserveListener(folder, PROP_DEFAULT_SELECTION_LISTENER, folder.isListening(14));
        WidgetLCAUtil.preserveListener(folder, PROP_FOLDER_LISTENER, this.hasFolderListener(folder));
    }

    public void readData(Widget widget) {
        final CTabFolder folder = (CTabFolder)widget;
        String value = WidgetLCAUtil.readPropertyValue(folder, PARAM_MINIMIZED);
        if (value != null) {
            folder.setMinimized(Boolean.valueOf(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(folder, PARAM_MAXIMIZED)) != null) {
            folder.setMaximized(Boolean.valueOf(value));
        }
        CTabFolderLCA.processFolderEvent(folder);
        String selectedItemId = WidgetLCAUtil.readPropertyValue(folder, "selection");
        if (selectedItemId != null) {
            final CTabItem item = (CTabItem)WidgetUtil.find(folder, selectedItemId);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    folder.setSelection(item);
                    WidgetLCAUtil.preserveProperty((Widget)folder, "selection", folder.getSelection());
                    ControlLCAUtil.processSelection(folder, item, false);
                    ControlLCAUtil.processDefaultSelection(folder, item);
                }
            });
        }
        ControlLCAUtil.processEvents(folder);
        ControlLCAUtil.processKeyEvents(folder);
        ControlLCAUtil.processMenuDetect(folder);
        WidgetLCAUtil.processHelp(folder);
    }

    public void renderInitialization(Widget widget) throws IOException {
        CTabFolder folder = (CTabFolder)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(folder);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(folder.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(folder, ALLOWED_STYLES));
        String[] toolTipTexts = new String[]{SWT.getMessage("SWT_Minimize"), SWT.getMessage("SWT_Maximize"), SWT.getMessage("SWT_Restore"), SWT.getMessage("SWT_ShowList"), SWT.getMessage("SWT_Close")};
        clientObject.set(PROP_TOOLTIP_TEXTS, toolTipTexts);
    }

    public void renderChanges(Widget widget) throws IOException {
        CTabFolder folder = (CTabFolder)widget;
        ControlLCAUtil.renderChanges(folder);
        WidgetLCAUtil.renderCustomVariant(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_TAB_POSITION, CTabFolderLCA.getTabPosition(folder), DEFAULT_TAB_POSITION);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_TAB_HEIGHT, folder.getTabHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MIN_MAX_STATE, CTabFolderLCA.getMinMaxState(folder), DEFAULT_MIN_MAX_STATE);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MINIMIZE_BOUNDS, CTabFolderLCA.getMinimizeBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MINIMIZE_VISIBLE, folder.getMinimizeVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MAXIMIZE_BOUNDS, CTabFolderLCA.getMaximizeBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MAXIMIZE_VISIBLE, folder.getMaximizeVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_CHEVRON_BOUNDS, CTabFolderLCA.getChevronBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_CHEVRON_VISIBLE, CTabFolderLCA.getChevronVisible(folder), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_UNSELECTED_CLOSE_VISIBLE, folder.getUnselectedCloseVisible(), true);
        WidgetLCAUtil.renderProperty((Widget)folder, "selection", folder.getSelection(), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_BACKGROUND, CTabFolderLCA.getSelectionBackground(folder), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_FOREGROUND, CTabFolderLCA.getSelectionForeground(folder), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_BACKGROUND_IMAGE, CTabFolderLCA.getSelectionBackgroundImage(folder), null);
        CTabFolderLCA.renderSelectionBackgroundGradient(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_BORDER_VISIBLE, folder.getBorderVisible(), false);
        WidgetLCAUtil.renderListener(folder, PROP_SELECTION_LISTENER, folder.isListening(13), false);
        WidgetLCAUtil.renderListener(folder, PROP_DEFAULT_SELECTION_LISTENER, folder.isListening(14), false);
        WidgetLCAUtil.renderListener(folder, PROP_FOLDER_LISTENER, this.hasFolderListener(folder), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void preserveSelectionBgGradient(CTabFolder folder) {
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(folder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical);
    }

    private static void renderSelectionBackgroundGradient(CTabFolder folder) {
        boolean hasChanged;
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(folder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
        boolean bl = hasChanged = WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
        if (hasChanged) {
            Object[] gradient = null;
            if (bgGradientColors != null) {
                Object[] colors = new Object[bgGradientColors.length];
                Integer[] percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < colors.length) {
                    colors[i] = ProtocolUtil.getColorAsArray(bgGradientColors[i], false);
                    ++i;
                }
                i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = bgGradientPercents[i];
                    ++i;
                }
                gradient = new Object[]{colors, percents, bgGradientVertical};
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject(folder);
            clientObject.set(PROP_SELECTION_BG_GRADIENT, gradient);
        }
    }

    private static void processFolderEvent(CTabFolder folder) {
        String eventName = PROP_FOLDER_LISTENER;
        if (WidgetLCAUtil.wasEventSent(folder, eventName)) {
            String detail = WidgetLCAUtil.readEventPropertyValue(folder, eventName, "detail");
            if ("minimize".equals(detail)) {
                folder.notifyListeners(5032, new Event());
            } else if ("maximize".equals(detail)) {
                folder.notifyListeners(5033, new Event());
            } else if ("restore".equals(detail)) {
                folder.notifyListeners(5034, new Event());
            } else if ("close".equals(detail)) {
                String itemId = WidgetLCAUtil.readEventPropertyValue(folder, eventName, "item");
                CTabItem item = (CTabItem)WidgetUtil.find(folder, itemId);
                CTabFolderLCA.notifyCloseListeners(item);
            } else if ("showList".equals(detail)) {
                CTabFolderLCA.notifyShowListListeners(folder);
            }
        }
    }

    private static void notifyCloseListeners(final CTabItem item) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                boolean doit = CTabFolderLCA.sendCloseEvent(item);
                if (doit) {
                    item.dispose();
                }
            }
        });
    }

    private static void notifyShowListListeners(final CTabFolder folder) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                boolean doit = CTabFolderLCA.sendShowListEvent(folder);
                if (doit) {
                    ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(folder);
                    adapter.showListMenu();
                }
            }
        });
    }

    private static boolean sendCloseEvent(CTabItem item) {
        Event event = new Event();
        event.item = item;
        event.doit = true;
        item.getParent().notifyListeners(5031, event);
        return event.doit;
    }

    private static boolean sendShowListEvent(CTabFolder folder) {
        Event event = new Event();
        Rectangle chevronRect = CTabFolderLCA.getChevronBounds(folder);
        event.x = chevronRect.x;
        event.y = chevronRect.y;
        event.height = chevronRect.height;
        event.width = chevronRect.width;
        event.doit = true;
        folder.notifyListeners(5035, event);
        return event.doit;
    }

    private static String getTabPosition(CTabFolder folder) {
        return folder.getTabPosition() == 128 ? DEFAULT_TAB_POSITION : "bottom";
    }

    private static String getMinMaxState(CTabFolder folder) {
        String result = DEFAULT_MIN_MAX_STATE;
        if (folder.getMinimized()) {
            result = "min";
        } else if (folder.getMaximized()) {
            result = "max";
        }
        return result;
    }

    private static Rectangle getMinimizeBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getMinimizeRect();
    }

    private static Rectangle getMaximizeBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getMaximizeRect();
    }

    private static Rectangle getChevronBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getChevronRect();
    }

    private static boolean getChevronVisible(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getChevronVisible();
    }

    private static Color getSelectionBackground(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionBackground();
    }

    private static Color getSelectionForeground(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionForeground();
    }

    private static Image getSelectionBackgroundImage(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionBackgroundImage();
    }

    private static ICTabFolderAdapter getCTabFolderAdapter(CTabFolder folder) {
        return folder.getAdapter(ICTabFolderAdapter.class);
    }

    private boolean hasFolderListener(CTabFolder folder) {
        return folder.isListening(5031) || folder.isListening(5033) || folder.isListening(5032) || folder.isListening(5034) || folder.isListening(5035);
    }
}

