/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.StringTokenizer;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    private static final int SPACING = 20;
    private static final int BUTTON_WIDTH = 61;
    private static final int MAX_WIDTH = 640;
    private Image image;
    private String message;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
        this.message = "";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.message = string;
    }

    public int open() {
        this.checkOperationMode();
        this.prepareOpen();
        this.runEventLoop(this.shell);
        return this.returnCode;
    }

    protected void prepareOpen() {
        this.determineImageFromStyle();
        this.shell = new Shell(this.parent, 67616);
        this.shell.setText(this.title);
        this.createControls();
        this.shell.setBounds(this.computeShellBounds());
        this.shell.pack();
    }

    private void determineImageFromStyle() {
        this.image = null;
        int systemImageId = -1;
        if ((this.style & 1) != 0) {
            systemImageId = 1;
        } else if ((this.style & 2) != 0) {
            systemImageId = 2;
        } else if ((this.style & 4) != 0) {
            systemImageId = 4;
        } else if ((this.style & 8) != 0) {
            systemImageId = 8;
        } else if ((this.style & 0x10) != 0) {
            systemImageId = 16;
        }
        if (systemImageId != -1) {
            this.image = this.parent.getDisplay().getSystemImage(systemImageId);
        }
    }

    private Rectangle computeShellBounds() {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        Point preferredSize = this.shell.computeSize(-1, -1);
        Rectangle parentSize = this.parent.getBounds();
        result.x = (parentSize.width - preferredSize.x) / 2 + parentSize.x;
        result.y = (parentSize.height - preferredSize.y) / 2 + parentSize.y;
        result.width = Math.min(preferredSize.x, 640);
        result.height = preferredSize.y;
        return result;
    }

    private void createControls() {
        this.shell.setLayout(new GridLayout(2, false));
        this.createImage();
        this.createText();
        this.createButtons();
    }

    private void createText() {
        Label textLabel = new Label(this.shell, 64);
        GridData data = new GridData(256);
        int imageWidth = this.image == null ? 0 : this.image.getBounds().width;
        int maxTextWidth = 640 - imageWidth - 20;
        int maxLineWidth = this.getMaxMessageLineWidth();
        if (maxLineWidth > maxTextWidth) {
            data.widthHint = maxTextWidth;
        }
        textLabel.setLayoutData(data);
        textLabel.setText(this.message);
    }

    private void createImage() {
        if (this.image != null) {
            Label label = new Label(this.shell, 0x1000000);
            GridData data = new GridData(0x1000000, 128, false, false);
            data.widthHint = this.image.getBounds().width + 20;
            label.setLayoutData(data);
            label.setImage(this.image);
        }
    }

    private void createButtons() {
        Composite buttonArea = new Composite(this.shell, 0);
        buttonArea.setLayout(new GridLayout(0, true));
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.horizontalSpan = 2;
        buttonArea.setLayoutData(buttonData);
        this.createButton(buttonArea, SWT.getMessage("SWT_Yes"), 64);
        this.createButton(buttonArea, SWT.getMessage("SWT_No"), 128);
        this.createButton(buttonArea, SWT.getMessage("SWT_OK"), 32);
        this.createButton(buttonArea, SWT.getMessage("SWT_Abort"), 512);
        this.createButton(buttonArea, SWT.getMessage("SWT_Retry"), 1024);
        this.createButton(buttonArea, SWT.getMessage("SWT_Cancel"), 256);
        this.createButton(buttonArea, SWT.getMessage("SWT_Ignore"), 2048);
        buttonArea.getChildren()[0].forceFocus();
    }

    private void createButton(Composite parent, String text, final int buttonId) {
        if ((this.style & buttonId) == buttonId) {
            ++((GridLayout)parent.getLayout()).numColumns;
            Button result = new Button(parent, 8);
            GridData data = new GridData(256);
            int widthHint = MessageBox.convertHorizontalDLUsToPixels(this.shell, 61);
            Point minSize = result.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            result.setLayoutData(data);
            result.setText(text);
            result.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MessageBox.this.returnCode = buttonId;
                    MessageBox.this.shell.close();
                }
            });
        }
    }

    private int getMaxMessageLineWidth() {
        Font font = this.shell.getFont();
        int result = 0;
        StringTokenizer tokenizer = new StringTokenizer(this.message, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int lineWidth = Graphics.stringExtent((Font)font, (String)line).x;
            result = Math.max(result, lineWidth);
        }
        return result;
    }

    private static int checkStyle(int style) {
        int chkStyle = 0;
        int mask = 4064;
        int bits = style & mask;
        chkStyle = bits == 32 || bits == 288 ? style : (bits == 192 || bits == 448 ? style : (bits == 1280 || bits == 3584 ? style : style & ~mask | 0x20));
        return chkStyle;
    }
}

