/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.eclipse.rtp.core.model.SourceProvider;
import org.eclipse.rtp.core.model.SourceUnMarshaller;
import org.eclipse.rtp.core.util.ModelUtil;

public class RestTemplate {
    SourceUnMarshaller unMarshaller;
    private final String urlBase;

    public RestTemplate(String newIntanceURI) {
        this.urlBase = newIntanceURI;
        this.unMarshaller = ModelUtil.getSourceUnMarshaller();
    }

    public <T> List<T> getForEntitiesAsList(String string, Class<T> clazz) {
        GetMethod method = new GetMethod(String.valueOf(this.urlBase) + string);
        try {
            this.executeMethod((HttpMethodBase)method);
            SourceProvider provider = this.getProvider((HttpMethodBase)method);
            List list = provider.getSources();
            return list;
        }
        finally {
            method.releaseConnection();
        }
    }

    private void executeMethod(HttpMethodBase method) {
        try {
            int statusCode = new HttpClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new IllegalStateException("Error querying REST interface.");
            }
        }
        catch (HttpException httpException) {
            throw new IllegalStateException("Error querying REST interface.");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error querying REST interface.");
        }
    }

    public void put(String string) {
        PutMethod method = new PutMethod(String.valueOf(this.urlBase) + string);
        this.executeMethod((HttpMethodBase)method);
    }

    public void get(String string) {
        GetMethod method = new GetMethod(String.valueOf(this.urlBase) + string);
        this.executeMethod((HttpMethodBase)method);
    }

    public void delete(String string) {
        DeleteMethod method = new DeleteMethod(String.valueOf(this.urlBase) + string);
        this.executeMethod((HttpMethodBase)method);
    }

    private SourceProvider getProvider(HttpMethodBase method) {
        SourceProvider sourceProvider;
        block9: {
            InputStream responseStream = null;
            try {
                try {
                    responseStream = method.getResponseBodyAsStream();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error querying REST interface.");
                }
                sourceProvider = this.unMarshaller.marshal(responseStream);
                if (responseStream == null) break block9;
            }
            catch (Throwable throwable) {
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                responseStream.close();
            }
            catch (IOException iOException) {}
        }
        return sourceProvider;
    }
}

