/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.rtp.configurator.ui.ComponentsTabContentUtil;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class SourcesLabelProvider
implements ITableLabelProvider {
    private Image httpSource;
    private final ComponentsTabContentUtil contentUtil;

    public SourcesLabelProvider(ComponentsTabContentUtil contentUtil) {
        this.contentUtil = contentUtil;
    }

    public void init(Display display) {
        this.httpSource = new Image((Device)display, this.getClass().getResourceAsStream("/images/rtp-icon.png"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex == 0 && element instanceof Source) {
            result = this.httpSource;
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (columnIndex == 0) {
            if (element instanceof Source) {
                result = ((Source)element).getName();
            } else if (element instanceof SourceVersion) {
                result = ((SourceVersion)element).getVersion();
            }
        } else if (columnIndex == 1 && element instanceof SourceVersion) {
            result = ((SourceVersion)element).getRepositoryUrl().toString();
        } else if (columnIndex == 2 && element instanceof SourceVersion) {
            boolean installed = this.contentUtil.isInstalled((SourceVersion)element);
            result = installed ? "installed" : "uninstalled";
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

