/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class UiHelper {
    private UiHelper() {
    }

    public static Shell createShell(Display display) {
        Shell shell = new Shell(display, 8);
        shell.setMaximized(true);
        shell.setLayout(UiHelper.createGreedyGridLayout());
        return shell;
    }

    public static Button createPushButton(Composite composite, String text) {
        return UiHelper.createPushButton(composite, 1, text);
    }

    public static Button createPushButton(Composite composite, int horizontalSpan, String text) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)UiHelper.createOneLinerGridData(horizontalSpan));
        button.setText(text);
        return button;
    }

    public static Label createLabel(Composite composite, int horizontalSpan, String text) {
        Label label = new Label(composite, 1);
        label.setText(text);
        label.setLayoutData((Object)UiHelper.createOneLinerGridData(horizontalSpan));
        return label;
    }

    public static TreeViewer createTreeViewer(Composite tab) {
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        tab.setLayout((Layout)treeColumnLayout);
        tab.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(tab, 768);
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 4;
        tree.setLayoutData((Object)layoutData);
        TreeColumn column0 = new TreeColumn(viewer.getTree(), 16384);
        column0.setText("Component");
        column0.setAlignment(16384);
        treeColumnLayout.setColumnData((Widget)column0, (ColumnLayoutData)new ColumnWeightData(1, true));
        column0.setWidth(300);
        TreeColumn column1 = new TreeColumn(viewer.getTree(), 16384);
        column1.setText("Repository");
        column1.setAlignment(16384);
        treeColumnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(4, true));
        TreeColumn column3 = new TreeColumn(viewer.getTree(), 16384);
        column3.setText("Status");
        column3.setAlignment(16384);
        treeColumnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(1, true));
        return viewer;
    }

    public static Tree createTree(Composite composite) {
        Tree tree = new Tree(composite, 2048);
        tree.setLayoutData((Object)UiHelper.createGreedyGridData());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn column0 = new TreeColumn(tree, 16384);
        column0.setText("Name");
        column0.setAlignment(16384);
        column0.setWidth(300);
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText("Description");
        column1.setAlignment(16384);
        column1.setWidth(260);
        return tree;
    }

    public static GridData createGreedyGridData() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createOneLinerGridData(int horizontalSpan) {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = horizontalSpan;
        return gridData;
    }

    public static Composite createGreedyGridComposite(Composite parent, int numColumns, boolean equalWidth) {
        Composite composite = new Composite(parent, 1);
        composite.setLayout(UiHelper.createGridLayout(numColumns, equalWidth));
        composite.setLayoutData((Object)UiHelper.createGreedyGridData());
        return composite;
    }

    public static Composite createGridComposite(Composite parent, int numColumns, boolean equalWidth) {
        Composite composite = new Composite(parent, 1);
        composite.setLayout(UiHelper.createGridLayout(numColumns, equalWidth));
        composite.setLayoutData((Object)UiHelper.createOneLinerGridData(numColumns));
        return composite;
    }

    private static Layout createGridLayout(int numColumns, boolean equalWidth) {
        GridLayout layout = new GridLayout(numColumns, equalWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static Layout createGreedyGridLayout() {
        return UiHelper.createGridLayout(1, true);
    }

    public static Text createText(Composite composite, String toolTip) {
        return UiHelper.createText(composite, 1, toolTip);
    }

    public static Text createText(Composite parent, int horizontalSpan, String toolTip) {
        Text text = new Text(parent, 2048);
        text.setToolTipText(toolTip);
        text.setLayoutData((Object)UiHelper.createOneLinerGridData(horizontalSpan));
        return text;
    }

    public static Combo createComboBox(Composite parent, int horizontalSpan, String ... labels) {
        Combo combo = new Combo(parent, 8);
        combo.setItems(labels);
        combo.setLayoutData((Object)UiHelper.createOneLinerGridData(horizontalSpan));
        combo.setText(labels[0]);
        return combo;
    }
}

