/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.modeling.ValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelimitedListBindingImpl
extends ListBindingImpl {
    private ListEntryResource head;

    @Override
    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
    }

    @Override
    public ModelElementType type(Resource resource) {
        return this.property().getType();
    }

    @Override
    public final List<Resource> read() {
        List<String> strings = this.split(this.readListString());
        int count = strings.size();
        if (count == 0) {
            this.head = null;
        } else {
            if (this.head == null) {
                this.head = this.createListEntryResource();
            }
            int i = 0;
            ListEntryResource prev = null;
            ListEntryResource entry = this.head;
            while (i < count && entry != null) {
                entry.value = strings.get(i);
                ++i;
                prev = entry;
                entry = entry.next;
            }
            entry = prev;
            while (entry.next != null) {
                entry.next.remove();
            }
            while (i < count) {
                entry = entry.insertAfter();
                entry.value = strings.get(i);
                ++i;
            }
        }
        ArrayList<Resource> base = new ArrayList<Resource>();
        if (this.head != null) {
            ListEntryResource entry = this.head;
            while (entry != null) {
                base.add(entry);
                entry = entry.next;
            }
        }
        return base;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Resource add(ModelElementType type) {
        block1: {
            entry = this.head;
            if (entry != null) ** GOTO lbl6
            this.head = entry = this.createListEntryResource();
            break block1;
lbl-1000:
            // 1 sources

            {
                entry = ListEntryResource.access$1(entry);
lbl6:
                // 2 sources

                ** while (ListEntryResource.access$1((ListEntryResource)entry) != null)
            }
lbl7:
            // 1 sources

            entry = ListEntryResource.access$2(entry);
        }
        this.writeListString();
        return entry;
    }

    @Override
    public void remove(Resource resource) {
        ((ListEntryResource)resource).remove();
        this.writeListString();
    }

    @Override
    public final void swap(Resource x, Resource y) {
        ListEntryResource a = (ListEntryResource)x;
        ListEntryResource b = (ListEntryResource)y;
        if (a.next == b) {
            ListEntryResource aPrev = a.prev;
            ListEntryResource bNext = b.next;
            a.prev = b;
            a.next = bNext;
            b.prev = aPrev;
            b.next = a;
            if (aPrev != null) {
                aPrev.next = b;
            }
            if (bNext != null) {
                bNext.prev = a;
            }
            if (a == this.head) {
                this.head = b;
            }
        } else if (b.next == a) {
            this.swap(y, x);
        } else {
            throw new UnsupportedOperationException();
        }
        this.writeListString();
    }

    protected char getDelimiter() {
        return ',';
    }

    protected abstract String readListString();

    protected abstract void writeListString(String var1);

    private void writeListString() {
        String str;
        char delimiter = this.getDelimiter();
        if (this.head == null) {
            str = null;
        } else {
            StringBuilder buf = new StringBuilder();
            ListEntryResource entry = this.head;
            while (entry != null) {
                String val;
                if (entry != this.head) {
                    buf.append(delimiter);
                }
                if ((val = entry.value) != null) {
                    buf.append(val);
                }
                entry = entry.next;
            }
            str = buf.toString();
        }
        this.writeListString(str);
    }

    protected ListEntryResource createListEntryResource() {
        return new DefaultListEntryResource();
    }

    private List<String> split(String str) {
        char delimiter = this.getDelimiter();
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            int n = str.length();
            while (i < n) {
                char ch = str.charAt(i);
                if (ch == delimiter) {
                    list.add(buf.toString());
                    buf = new StringBuilder();
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            list.add(buf.toString());
        }
        return list;
    }

    private final class DefaultListEntryResource
    extends ListEntryResource {
        private ValueProperty listEntryProperty;

        public DefaultListEntryResource() {
            ModelElementType listEntryType = DelimitedListBindingImpl.this.property().getType();
            for (ModelProperty prop : listEntryType.getProperties()) {
                if (this.listEntryProperty != null) {
                    throw new IllegalStateException();
                }
                if (prop instanceof ValueProperty) {
                    this.listEntryProperty = (ValueProperty)prop;
                    continue;
                }
                throw new IllegalStateException();
            }
            if (this.listEntryProperty == null) {
                throw new IllegalStateException();
            }
        }

        protected BindingImpl createBinding(ModelProperty property) {
            if (property == this.listEntryProperty) {
                return new ValueBindingImpl(){

                    public String read() {
                        return DefaultListEntryResource.this.getValue();
                    }

                    public void write(String value) {
                        DefaultListEntryResource.this.setValue(value);
                    }
                };
            }
            return null;
        }
    }

    public abstract class ListEntryResource
    extends Resource {
        private ListEntryResource prev;
        private ListEntryResource next;
        private String value;

        public ListEntryResource() {
            super(DelimitedListBindingImpl.this.element().resource());
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            List segments = DelimitedListBindingImpl.this.split(value);
            int count = segments.size();
            if (count == 0) {
                this.value = null;
            } else {
                this.value = (String)segments.get(0);
                int i = 1;
                while (i < count) {
                    ListEntryResource entry = this.insertAfter();
                    entry.setValue((String)segments.get(i));
                    ++i;
                }
            }
            DelimitedListBindingImpl.this.writeListString();
        }

        public final void remove() {
            if (this == DelimitedListBindingImpl.this.head) {
                DelimitedListBindingImpl.this.head = this.next;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.prev = null;
            this.next = null;
        }

        private ListEntryResource insertAfter() {
            ListEntryResource entry = DelimitedListBindingImpl.this.createListEntryResource();
            entry.prev = this;
            entry.next = this.next;
            this.next = entry;
            if (entry.next != null) {
                entry.next.prev = entry;
            }
            return entry;
        }
    }
}

