/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceStore
extends ByteArrayResourceStore {
    private final File file;

    public FileResourceStore(File file) throws ResourceStoreException {
        this.file = file;
        if (this.file.exists()) {
            try {
                FileInputStream in = new FileInputStream(this.file);
                try {
                    this.setContents(in);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                throw new ResourceStoreException(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            FileUtil.mkdirs(this.file.getParentFile());
        }
        catch (CoreException e) {
            throw new ResourceStoreException(e);
        }
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                ((OutputStream)out).write(this.getContents());
                out.flush();
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public void validateSave() {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new ValidateEditException();
        }
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        File result = null;
        result = adapterType == File.class ? this.file : super.adapt(adapterType);
        return (A)result;
    }
}

