/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IdentityCache;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayeredListBindingImpl
extends ListBindingImpl {
    private final IdentityCache<Object, Resource> cache = new IdentityCache();

    @Override
    public final List<Resource> read() {
        this.cache.track();
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Object obj : this.readUnderlyingList()) {
            Resource resource = this.cache.get(obj);
            if (resource == null) {
                resource = this.createResource(obj);
                this.cache.put(obj, resource);
            }
            list.add(resource);
        }
        this.cache.purge();
        return list;
    }

    protected abstract List<?> readUnderlyingList();

    @Override
    public final Resource add(ModelElementType type) {
        Object obj = this.addUnderlyingObject(type);
        Resource resource = this.createResource(obj);
        this.cache.put(obj, resource);
        return resource;
    }

    protected Object addUnderlyingObject(ModelElementType type) {
        throw new UnsupportedOperationException();
    }

    protected abstract Resource createResource(Object var1);
}

