/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListProperty
extends ModelProperty {
    public ListProperty(ModelElementType type, String propertyName) {
        super(type, propertyName, null);
    }

    public ListProperty(ModelElementType type, ListProperty baseProperty) {
        super(type, baseProperty.getName(), baseProperty);
    }

    @Override
    protected List<ModelPropertyValidator<? extends Object>> createValidators() {
        List<ModelPropertyValidator<? extends Object>> validators = super.createValidators();
        CountConstraint countConstraint = this.getAnnotation(CountConstraint.class);
        if (countConstraint != null) {
            validators.add(new CountConstraintValidator(countConstraint));
        }
        return validators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CountConstraintValidator
    extends ModelPropertyValidator<ModelElementList<?>> {
        private final CountConstraint constraint;

        public CountConstraintValidator(CountConstraint constraint) {
            this.constraint = constraint;
        }

        @Override
        public IStatus validate(ModelElementList<?> list) {
            int count = list.size();
            String message = null;
            if (count < this.constraint.min()) {
                message = this.constraint.min() == 1 ? Resources.bind((String)Resources.countConstraintTooFewAtLeastOne, (Object)ListProperty.this.getType().getLabel(true, CapitalizationType.NO_CAPS, false)) : Resources.bind((String)Resources.countConstraintTooFew, (Object)ListProperty.this.getType().getLabel(true, CapitalizationType.NO_CAPS, false), (Object)String.valueOf(this.constraint.min()));
            } else if (count > this.constraint.max()) {
                message = Resources.bind((String)Resources.countConstraintTooMany, (Object)ListProperty.this.getType().getLabel(true, CapitalizationType.NO_CAPS, false), (Object)String.valueOf(this.constraint.max()));
            }
            if (message == null) {
                return Status.OK_STATUS;
            }
            return new Status(4, "abc", message);
        }
    }

    private static final class Resources
    extends NLS {
        public static String countConstraintTooFew;
        public static String countConstraintTooFewAtLeastOne;
        public static String countConstraintTooMany;

        static {
            Resources.initializeMessages((String)ListProperty.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

