/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.EnablementService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementHandle<T extends IModelElement> {
    private final IModelElement parent;
    private final ElementProperty property;
    private final ElementBindingImpl binding;
    private T element;
    private Boolean enabledState;
    private IStatus validationState;

    public ModelElementHandle(IModelElement parent, ElementProperty property) {
        this.parent = parent;
        this.property = property;
        this.binding = parent.resource().binding(property);
    }

    public void init() {
        this.refreshInternal();
    }

    public IModelElement root() {
        return (IModelElement)this.parent.root();
    }

    public IModelElement parent() {
        return this.parent;
    }

    public T element() {
        return this.element(false);
    }

    public T element(boolean createIfNecessary) {
        if (createIfNecessary) {
            List<ModelElementType> types = this.property.getAllPossibleTypes();
            if (types.size() > 1) {
                throw new IllegalArgumentException();
            }
            return this.element(true, types.get(0));
        }
        return this.element(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(boolean createIfNecessary, ModelElementType type) {
        if (type != null && !this.property.getAllPossibleTypes().contains(type)) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        if (createIfNecessary) {
            ModelElementType t = type;
            if (t == null) {
                List<ModelElementType> types = this.property.getAllPossibleTypes();
                if (types.size() > 1) {
                    throw new IllegalArgumentException();
                }
                t = types.get(0);
            }
            ModelElementHandle modelElementHandle = this;
            synchronized (modelElementHandle) {
                if (this.element == null) {
                    this.refresh();
                }
                if (this.element != null && this.element.getModelElementType() != t) {
                    this.remove();
                }
                if (this.element == null) {
                    Resource resource = this.binding.create(t);
                    this.element = t.instantiate(this.parent, this.property, resource);
                    this.refreshEnabledState();
                    this.refreshValidationState();
                    changed = true;
                }
            }
        }
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.element != null && type != null && this.element.getModelElementType() != type) {
                throw new IllegalArgumentException();
            }
        }
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validate() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.validationState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.enabledState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        boolean changed = false;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.element != null) {
                this.binding.remove();
                changed = this.refreshInternal();
            }
        }
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removable() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.binding.removable();
        }
    }

    public void refresh() {
        boolean changed = this.refreshInternal();
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshInternal() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean changed = false;
            Resource oldResource = this.element == null ? null : this.element.resource();
            Resource newResource = this.binding.read();
            if (newResource != oldResource) {
                if (newResource == null) {
                    this.element = null;
                } else {
                    ModelElementType type = this.binding.type(newResource);
                    this.element = type.instantiate(this.parent, this.property, newResource);
                }
                changed = true;
            }
            changed = this.refreshEnabledState() || changed;
            changed = this.refreshValidationState() || changed;
            return changed;
        }
    }

    private boolean refreshEnabledState() {
        Boolean newEnabledState;
        Boolean oldEnabledState = this.enabledState;
        this.enabledState = newEnabledState = Boolean.valueOf(this.parent.service(this.property, EnablementService.class).isEnabled());
        return oldEnabledState != null && !oldEnabledState.equals(newEnabledState);
    }

    private boolean refreshValidationState() {
        IStatus oldValidationState = this.validationState;
        SapphireMultiStatus newValidationState = new SapphireMultiStatus();
        if (this.enabled()) {
            ModelPropertyValidator<?> validator = this.property.getValidator();
            if (validator != null) {
                newValidationState.merge(validator.validate(this.element));
            }
            if (this.element != null) {
                newValidationState.merge(this.element.validate());
            }
        }
        if (!newValidationState.equals(oldValidationState)) {
            this.validationState = newValidationState;
            return oldValidationState != null;
        }
        return false;
    }
}

