/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelPath {
    private static final ModelRootSegment MODEL_ROOT_SEGMENT = new ModelRootSegment();
    private static final ParentElementSegment PARENT_ELEMENT_SEGMENT = new ParentElementSegment();
    private static final AllSiblingsSegment ALL_SIBLINGS_SEGMENT = new AllSiblingsSegment();
    private static final AllDescendentsSegment ALL_DESCENDENTS_SEGMENT = new AllDescendentsSegment();
    private final List<Segment> segments;
    private final int offset;

    public ModelPath(String path) throws MalformedPathException {
        this(ModelPath.parse(path), 0);
    }

    private ModelPath(List<Segment> segments, int offset) throws MalformedPathException {
        this.segments = segments;
        this.offset = offset;
        if (this.length() == 0) {
            throw new MalformedPathException("Cannot construct a zero-length path.");
        }
        Segment tail = segments.get(segments.size() - 1);
        if (tail instanceof ModelRootSegment) {
            throw new MalformedPathException("A model path cannot end with model root reference.");
        }
        if (tail instanceof ParentElementSegment) {
            throw new MalformedPathException("A model path cannot end with parent element reference.");
        }
    }

    public int length() {
        return this.segments.size() - this.offset;
    }

    public Segment head() {
        return this.segments.get(this.offset);
    }

    public ModelPath tail() throws MalformedPathException {
        return new ModelPath(this.segments, this.offset + 1);
    }

    public ModelPath append(ModelPath path) throws MalformedPathException {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int i = this.offset;
        int n = this.segments.size();
        while (i < n) {
            segments.add(this.segments.get(i));
            ++i;
        }
        i = path.offset;
        n = path.segments.size();
        while (i < n) {
            segments.add(path.segments.get(i));
            ++i;
        }
        return new ModelPath(segments, 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelPath) {
            ModelPath p = (ModelPath)obj;
            int size = this.segments.size();
            if (size == p.segments.size()) {
                int i = 0;
                while (i < size) {
                    if (!this.segments.get(i).equals(p.segments.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Segment segment : this.segments) {
            hashCode += segment.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = this.offset;
        int n = this.segments.size();
        while (i < n) {
            int buflen = buf.length();
            if (buflen > 0 && buf.charAt(buflen - 1) != '/') {
                buf.append('/');
            }
            buf.append(this.segments.get(i).toString());
            ++i;
        }
        return buf.toString();
    }

    private static List<Segment> parse(String path) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        if ((path = path.trim()).startsWith("/")) {
            segments.add(MODEL_ROOT_SEGMENT);
            path = path.substring(1);
        }
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() == 0) {
                throw new IllegalArgumentException(path);
            }
            if (part.equals("..")) {
                segments.add(PARENT_ELEMENT_SEGMENT);
            } else if (part.equals("*")) {
                segments.add(ALL_DESCENDENTS_SEGMENT);
            } else if (part.equals("#")) {
                segments.add(ALL_SIBLINGS_SEGMENT);
            } else {
                int openBracket = part.indexOf(91);
                if (openBracket != -1) {
                    int closeBracket = part.indexOf(93);
                    if (closeBracket - openBracket <= 1) {
                        throw new IllegalArgumentException(path);
                    }
                    if (openBracket == 0 || closeBracket != part.length() - 1) {
                        throw new IllegalArgumentException(path);
                    }
                    segments.add(new PropertySegment(part.substring(0, openBracket)));
                    segments.add(new TypeFilterSegment(part.substring(openBracket + 1, closeBracket)));
                } else {
                    segments.add(new PropertySegment(part));
                }
            }
            ++n2;
        }
        if (segments.size() > 1 && segments.get(0) instanceof AllDescendentsSegment) {
            segments.set(0, ALL_SIBLINGS_SEGMENT);
        }
        return segments;
    }

    public static final class AllDescendentsSegment
    extends Segment {
        private AllDescendentsSegment() {
        }

        public String toString() {
            return "*";
        }
    }

    public static final class AllSiblingsSegment
    extends Segment {
        private AllSiblingsSegment() {
        }

        public String toString() {
            return "#";
        }
    }

    public static final class MalformedPathException
    extends RuntimeException {
        public MalformedPathException(String message) {
            super(message);
        }
    }

    public static final class ModelRootSegment
    extends Segment {
        private ModelRootSegment() {
        }

        public String toString() {
            return "/";
        }
    }

    public static final class ParentElementSegment
    extends Segment {
        private ParentElementSegment() {
        }

        public String toString() {
            return "..";
        }
    }

    public static final class PropertySegment
    extends Segment {
        private final String property;

        private PropertySegment(String property) {
            this.property = property;
        }

        public String getPropertyName() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertySegment) {
                return this.property.equals(((PropertySegment)obj).property);
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        public String toString() {
            return this.property;
        }
    }

    public static abstract class Segment {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TypeFilterSegment
    extends Segment {
        private final Set<String> types;

        private TypeFilterSegment(String expr) {
            if (!expr.startsWith("#type=") || expr.length() < 7) {
                throw new IllegalArgumentException(expr);
            }
            String typesAsString = expr.substring(6).trim();
            HashSet<String> types = new HashSet<String>();
            String[] stringArray = typesAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                types.add(type);
                ++n2;
            }
            this.types = Collections.unmodifiableSet(types);
        }

        public Set<String> getTypes() {
            return this.types;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeFilterSegment) {
                return this.types.equals(((TypeFilterSegment)obj).types);
            }
            return false;
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[#type=");
            boolean first = true;
            for (String type : this.types) {
                if (!first) {
                    buf.append(',');
                }
                buf.append(type);
                first = false;
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

