/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.DoubleValueKeyword;
import org.eclipse.sapphire.modeling.FloatValueKeyword;
import org.eclipse.sapphire.modeling.IntegerValueKeyword;
import org.eclipse.sapphire.modeling.LongValueKeyword;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.BasePathsProvider;
import org.eclipse.sapphire.modeling.annotations.EclipseWorkspacePath;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.java.JavaPackageName;
import org.eclipse.sapphire.modeling.java.JavaTypeConstraints;
import org.eclipse.sapphire.modeling.java.JavaTypeName;
import org.eclipse.sapphire.modeling.java.internal.JavaTypeNameValidator;
import org.eclipse.sapphire.modeling.java.internal.QualifiedJavaIdentifierValueValidator;
import org.eclipse.sapphire.modeling.validators.AbsolutePathValueValidator;
import org.eclipse.sapphire.modeling.validators.BasicValueValidator;
import org.eclipse.sapphire.modeling.validators.EclipseWorkspacePathValueValidator;
import org.eclipse.sapphire.modeling.validators.NumericRangeValidator;
import org.eclipse.sapphire.modeling.validators.PossibleValuesValidator;
import org.eclipse.sapphire.modeling.validators.ReferenceValueValidator;
import org.eclipse.sapphire.modeling.validators.RelativePathValueValidator;
import org.eclipse.sapphire.modeling.validators.UniqueValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueProperty
extends ModelProperty {
    private static final Set<ValueKeyword> NO_KEYWORDS = Collections.emptySet();
    private static final Set<ValueKeyword> INTEGER_KEYWORDS;
    private static final Set<ValueKeyword> LONG_KEYWORDS;
    private static final Set<ValueKeyword> FLOAT_KEYWORDS;
    private static final Set<ValueKeyword> DOUBLE_KEYWORDS;
    private final Set<ValueKeyword> keywords;

    static {
        HashSet<ValueKeyword> keywords = new HashSet<ValueKeyword>();
        keywords.add(new IntegerValueKeyword("max-int", String.valueOf(Integer.MAX_VALUE)));
        keywords.add(new IntegerValueKeyword("min-int", String.valueOf(Integer.MIN_VALUE)));
        INTEGER_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new LongValueKeyword("max-long", String.valueOf(Long.MAX_VALUE)));
        keywords.add(new LongValueKeyword("min-long", String.valueOf(Long.MIN_VALUE)));
        LONG_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new FloatValueKeyword("max-float", String.valueOf(Float.MAX_VALUE)));
        keywords.add(new FloatValueKeyword("min-float", String.valueOf(Float.MIN_VALUE)));
        FLOAT_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new DoubleValueKeyword("max-double", String.valueOf(Double.MAX_VALUE)));
        keywords.add(new DoubleValueKeyword("min-double", String.valueOf(Double.MIN_VALUE)));
        DOUBLE_KEYWORDS = Collections.unmodifiableSet(keywords);
    }

    public ValueProperty(ModelElementType type, String propertyName) {
        this(type, propertyName, null);
    }

    public ValueProperty(ModelElementType type, ValueProperty baseProperty) {
        this(type, baseProperty.getName(), baseProperty);
    }

    private ValueProperty(ModelElementType type, String propertyName, ValueProperty baseProperty) {
        super(type, propertyName, baseProperty);
        Class<?> propType = this.getTypeClass();
        this.keywords = propType == Integer.class ? INTEGER_KEYWORDS : (propType == Long.class ? LONG_KEYWORDS : (propType == Float.class ? FLOAT_KEYWORDS : (propType == Double.class ? DOUBLE_KEYWORDS : NO_KEYWORDS)));
    }

    @Override
    protected List<ModelPropertyValidator<? extends Object>> createValidators() {
        NumericRange rangeConstraintAnnotation;
        Class<?> type;
        List<ModelPropertyValidator<? extends Object>> validators = super.createValidators();
        if (this.hasAnnotation(NonNullValue.class)) {
            final String labelText = this.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
            ModelPropertyValidator nullValueValidator = new ModelPropertyValidator<Value<?>>(){

                @Override
                public IStatus validate(Value<?> value) {
                    if (value.getText() == null) {
                        String message = Resources.bind((String)Resources.nullValueValidationMessage, (Object)labelText);
                        return new Status(4, "org.eclipse.sapphire.modeling", message);
                    }
                    return Status.OK_STATUS;
                }
            };
            validators.add(nullValueValidator);
        }
        if (this.hasAnnotation(NoDuplicates.class)) {
            validators.add(new UniqueValueValidator());
        }
        if (this.hasAnnotation(Reference.class)) {
            validators.add(new ReferenceValueValidator());
        }
        if (JavaPackageName.class.isAssignableFrom(type = this.getTypeClass())) {
            validators.add(new QualifiedJavaIdentifierValueValidator());
        } else if (JavaTypeName.class.isAssignableFrom(type) || this.hasAnnotation(JavaTypeConstraints.class)) {
            validators.add(new QualifiedJavaIdentifierValueValidator());
            validators.add(new JavaTypeNameValidator(this));
        } else if (IPath.class.isAssignableFrom(type)) {
            if (this.hasAnnotation(AbsolutePath.class)) {
                validators.add(new AbsolutePathValueValidator(this));
            } else if (this.hasAnnotation(BasePathsProvider.class)) {
                validators.add(new RelativePathValueValidator(this));
            } else if (this.hasAnnotation(EclipseWorkspacePath.class)) {
                validators.add(new EclipseWorkspacePathValueValidator(this));
            }
        } else if (!String.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator());
        }
        if (PossibleValuesValidator.isNecessary(this)) {
            validators.add(new PossibleValuesValidator());
        }
        if ((rangeConstraintAnnotation = this.getAnnotation(NumericRange.class)) != null) {
            String minStr = rangeConstraintAnnotation.min();
            String maxStr = rangeConstraintAnnotation.max();
            if (minStr != null || maxStr != null) {
                try {
                    if (Integer.class.isAssignableFrom(type)) {
                        Integer min = minStr.length() > 0 ? Integer.valueOf(minStr) : null;
                        Integer max = maxStr.length() > 0 ? Integer.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>(min, max));
                    } else if (Long.class.isAssignableFrom(type)) {
                        Long min = minStr.length() > 0 ? Long.valueOf(minStr) : null;
                        Long max = maxStr.length() > 0 ? Long.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Long>(min, max));
                    } else if (Float.class.isAssignableFrom(type)) {
                        Float min = minStr.length() > 0 ? Float.valueOf(minStr) : null;
                        Float max = maxStr.length() > 0 ? Float.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Float>(min, max));
                    } else if (Double.class.isAssignableFrom(type)) {
                        Double min = minStr.length() > 0 ? Double.valueOf(minStr) : null;
                        Double max = maxStr.length() > 0 ? Double.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Double>(min, max));
                    } else if (BigInteger.class.isAssignableFrom(type)) {
                        BigInteger min = minStr.length() > 0 ? new BigInteger(minStr) : null;
                        BigInteger max = maxStr.length() > 0 ? new BigInteger(maxStr) : null;
                        validators.add(new NumericRangeValidator<BigInteger>(min, max));
                    } else if (BigDecimal.class.isAssignableFrom(type)) {
                        BigDecimal min = minStr.length() > 0 ? new BigDecimal(minStr) : null;
                        BigDecimal max = maxStr.length() > 0 ? new BigDecimal(maxStr) : null;
                        validators.add(new NumericRangeValidator<BigDecimal>(min, max));
                    }
                }
                catch (NumberFormatException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
        }
        return validators;
    }

    public Set<ValueKeyword> getKeywords() {
        return this.keywords;
    }

    public ValueKeyword getKeyword(String keyword) {
        for (ValueKeyword kwd : this.keywords) {
            if (!kwd.getKeyword().equals(keyword)) continue;
            return kwd;
        }
        return null;
    }

    public String decodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.decode(value);
                if (result != value) break;
            }
        }
        return result;
    }

    public String encodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.encode(value);
                if (result != value) break;
            }
        }
        return result;
    }

    @Override
    protected Set<ModelPath> initDependencies() {
        Set<ModelPath> dependencies = super.initDependencies();
        if (this.hasAnnotation(NoDuplicates.class)) {
            dependencies.add(new ModelPath("*/" + this.getName()));
        }
        return dependencies;
    }

    private static final class Resources
    extends NLS {
        public static String nullValueValidationMessage;

        static {
            Resources.initializeMessages((String)ValueProperty.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

