/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor.util;

import java.util.Set;
import org.eclipse.sapphire.modeling.annotations.processor.util.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayTypeReference
extends TypeReference {
    private static final String ARRAY_NOTATION = "[]";
    private static final String[] COMMON_ARRAY_DIMENSIONS = new String[5];
    private final TypeReference base;
    private final int dimensions;

    static {
        ArrayTypeReference.COMMON_ARRAY_DIMENSIONS[0] = "";
        int i = 1;
        while (i < COMMON_ARRAY_DIMENSIONS.length) {
            ArrayTypeReference.COMMON_ARRAY_DIMENSIONS[i] = String.valueOf(COMMON_ARRAY_DIMENSIONS[i - 1]) + ARRAY_NOTATION;
            ++i;
        }
    }

    public ArrayTypeReference(TypeReference base, int dimensions) {
        super(String.valueOf(base.getQualifiedName()) + ArrayTypeReference.generateArrayNotation(dimensions));
        if (base instanceof ArrayTypeReference) {
            throw new IllegalArgumentException();
        }
        this.base = base;
        this.dimensions = dimensions;
    }

    @Override
    public TypeReference getBase() {
        return this.base;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public void contributeNecessaryImports(Set<TypeReference> imports) {
        this.base.contributeNecessaryImports(imports);
    }

    private static String generateArrayNotation(int dimensions) {
        if (dimensions < COMMON_ARRAY_DIMENSIONS.length) {
            return COMMON_ARRAY_DIMENSIONS[dimensions];
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < dimensions) {
            buf.append(ARRAY_NOTATION);
            ++i;
        }
        return buf.toString();
    }
}

