/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeferredFunction
extends Function {
    private final String name;

    public DeferredFunction(String name) {
        this.name = name;
    }

    public static DeferredFunction create(String name, List<Function> operands) {
        DeferredFunction function = new DeferredFunction(name);
        function.init(operands);
        return function;
    }

    public String name() {
        return this.name;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){
            private FunctionResult baseResult;
            private FunctionResult.Listener listener;

            protected void init() {
                super.init();
                Function function = this.context().function(DeferredFunction.this.name(), DeferredFunction.this.operands());
                this.baseResult = function.evaluate(this.context());
                this.listener = new FunctionResult.Listener(){

                    public void handleValueChanged() {
                        this.refresh();
                    }
                };
                this.baseResult.addListener(this.listener);
            }

            protected Object evaluate() {
                return this.baseResult.value();
            }

            public void dispose() {
                super.dispose();
                this.baseResult.removeListener(this.listener);
            }
        };
    }
}

