/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class EqualityFunction
extends Function {
    public static EqualityFunction create(Function a, Function b) {
        EqualityFunction function = new EqualityFunction();
        function.init(a, b);
        return function;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object b;
                Object a = this.operand(0).value();
                if (a == (b = this.operand(1).value())) {
                    return true;
                }
                if (a == null) {
                    if (b instanceof Value) {
                        if (((Value)b).getText() == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                if (b == null) {
                    if (a instanceof Value) {
                        if (((Value)a).getText() == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal) {
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    BigDecimal y = this.cast(b, BigDecimal.class);
                    return x.equals(y);
                }
                if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
                    Double y;
                    Double x = this.cast(a, Double.class);
                    if (x == (y = this.cast(b, Double.class))) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    BigInteger x = this.cast(a, BigInteger.class);
                    BigInteger y = this.cast(b, BigInteger.class);
                    return x.equals(y);
                }
                if (a instanceof Byte || a instanceof Short || a instanceof Character || a instanceof Integer || a instanceof Long || b instanceof Byte || b instanceof Short || b instanceof Character || b instanceof Integer || b instanceof Long) {
                    Long y;
                    Long x = this.cast(a, Long.class);
                    if (x == (y = this.cast(b, Long.class))) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Boolean || b instanceof Boolean) {
                    Boolean y;
                    Boolean x = this.cast(a, Boolean.class);
                    if (x == (y = this.cast(b, Boolean.class))) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Enum) {
                    if (a == this.cast(b, a.getClass())) {
                        return true;
                    }
                    return false;
                }
                if (b instanceof Enum) {
                    if (this.cast(a, b.getClass()) == b) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof String || b instanceof String) {
                    String y;
                    String x = this.cast(a, String.class);
                    if (x.compareTo(y = this.cast(b, String.class)) == 0) {
                        return true;
                    }
                    return false;
                }
                return a.equals(b);
            }
        };
    }
}

