/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Function {
    private List<Function> operands;
    private List<Function> operandsReadOnly;

    public final void init(Function ... operands) {
        int count = operands.length;
        if (count == 0) {
            this.operands = Collections.emptyList();
            this.operandsReadOnly = this.operands;
        } else if (count == 1) {
            this.operands = Collections.singletonList(operands[0]);
            this.operandsReadOnly = this.operands;
        } else {
            this.operands = new ArrayList<Function>(count);
            Function[] functionArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                Function operand = functionArray[n2];
                this.operands.add(operand);
                ++n2;
            }
            this.operandsReadOnly = Collections.unmodifiableList(this.operands);
        }
    }

    public final void init(List<Function> operands) {
        int count = operands.size();
        if (count == 0) {
            this.operands = Collections.emptyList();
            this.operandsReadOnly = this.operands;
        } else if (count == 1) {
            this.operands = Collections.singletonList(operands.get(0));
            this.operandsReadOnly = this.operands;
        } else {
            this.operands = new ArrayList<Function>(count);
            this.operands.addAll(operands);
            this.operandsReadOnly = Collections.unmodifiableList(this.operands);
        }
    }

    public final List<Function> operands() {
        return this.operandsReadOnly;
    }

    public final Function operand(int position) {
        if (position < this.operands.size()) {
            return this.operands.get(position);
        }
        throw new FunctionException(NLS.bind((String)Resources.missingOperandMessage, (Object)this.getClass().getName(), (Object)String.valueOf(position)));
    }

    public abstract FunctionResult evaluate(FunctionContext var1);

    private static final class Resources
    extends NLS {
        public static String missingOperandMessage;

        static {
            Resources.initializeMessages((String)Function.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

