/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

public class ModelElementFunctionContext
extends FunctionContext {
    private final IModelElement element;
    private final LocalizationService localizationService;
    private final ModelPropertyListener listener;

    public ModelElementFunctionContext(IModelElement element) {
        this(element, SourceLanguageLocalizationService.INSTANCE);
    }

    public ModelElementFunctionContext(IModelElement element, LocalizationService localizationService) {
        this.element = element;
        this.localizationService = localizationService;
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                ModelProperty property;
                if (event != null && (property = event.getProperty()) != null) {
                    ModelElementFunctionContext.this.notifyListeners(property.getName());
                }
            }
        };
        this.element.addListener(this.listener, "*");
    }

    public final IModelElement element() {
        return this.element;
    }

    public Object property(String name) {
        ModelElementType type = this.element.getModelElementType();
        ModelProperty property = type.getProperty(name);
        if (property != null) {
            return this.element.read(property);
        }
        return super.property(name);
    }

    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public void dispose() {
        super.dispose();
        this.element.removeListener(this.listener, "*");
    }
}

