/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class PropertyAccessFunction
extends Function {
    public static PropertyAccessFunction create(Function element, Function property) {
        PropertyAccessFunction literal = new PropertyAccessFunction();
        literal.init(element, property);
        return literal;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){
            private ModelPropertyListener listener;
            private IModelElement element;
            private ModelProperty property;

            protected void init() {
                super.init();
                this.listener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        this.refresh();
                    }
                };
            }

            protected Object evaluate() {
                Object res;
                IModelElement el = this.cast(this.operand(0).value(), IModelElement.class);
                String pname = this.cast(this.operand(1).value(), String.class);
                ModelProperty p = el.getModelElementType().getProperty(pname);
                if (this.element != el || this.property != p) {
                    if (this.element != null) {
                        this.element.removeListener(this.listener, this.property.getName());
                    }
                    this.element = el;
                    this.property = p;
                    this.element.addListener(this.listener, this.property.getName());
                }
                if ((res = this.element.read(this.property)) instanceof ModelElementHandle) {
                    res = ((ModelElementHandle)res).element();
                }
                return res;
            }

            public void dispose() {
                super.dispose();
                if (this.element != null) {
                    this.element.removeListener(this.listener, this.property.getName());
                }
            }
        };
    }
}

