/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.internal.FunctionUtils;

public final class UnaryMinusFunction
extends Function {
    public static UnaryMinusFunction create(Function operand) {
        UnaryMinusFunction function = new UnaryMinusFunction();
        function.init(operand);
        return function;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object a = this.operand(0).value();
                if (a == null) {
                    return 0L;
                }
                if (a instanceof BigDecimal) {
                    return ((BigDecimal)a).negate();
                }
                if (a instanceof BigInteger) {
                    return ((BigInteger)a).negate();
                }
                if (a instanceof String) {
                    if (FunctionUtils.isDecimalString(a)) {
                        return -this.cast(a, Double.class).doubleValue();
                    }
                    return -this.cast(a, Long.class).longValue();
                }
                if (a instanceof Byte) {
                    return (int)(-((Byte)a).byteValue());
                }
                if (a instanceof Short) {
                    return (int)(-((Short)a).shortValue());
                }
                if (a instanceof Integer) {
                    return -((Integer)a).intValue();
                }
                if (a instanceof Long) {
                    return -((Long)a).longValue();
                }
                if (a instanceof Float) {
                    return Float.valueOf(-((Float)a).floatValue());
                }
                if (a instanceof Double) {
                    return -((Double)a).doubleValue();
                }
                throw new FunctionException(NLS.bind((String)Resources.cannotApplyMessage, (Object)a.getClass().getName()));
            }
        };
    }

    private static final class Resources
    extends NLS {
        public static String cannotApplyMessage;

        static {
            Resources.initializeMessages((String)UnaryMinusFunction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

