/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.DefaultValueService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultValueServiceFactory
extends ModelPropertyServiceFactory {
    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return property instanceof ValueProperty;
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        DefaultValueService svc = null;
        DefaultValue defaultValueAnnotation = property.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation != null) {
            if (!defaultValueAnnotation.service().equals(DefaultValueService.class)) {
                try {
                    svc = defaultValueAnnotation.service().newInstance();
                    svc.init(element, property, defaultValueAnnotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    svc = null;
                }
            } else {
                svc = new StaticDefaultValueService(defaultValueAnnotation.text());
            }
        }
        if (svc == null) {
            svc = new StaticDefaultValueService(null);
        }
        return svc;
    }

    private static final class StaticDefaultValueService
    extends DefaultValueService {
        private final String value;

        public StaticDefaultValueService(String value) {
            this.value = value;
        }

        public String getDefaultValue() {
            return this.value;
        }
    }
}

