/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.DerivedValueService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DerivedValue;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DerivedValueServiceFactory
extends ModelPropertyServiceFactory {
    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return property instanceof ValueProperty && property.hasAnnotation(DerivedValue.class);
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        DerivedValueService derivedValueProviderImpl = null;
        DerivedValue derivedValueAnnotation = property.getAnnotation(DerivedValue.class);
        if (derivedValueAnnotation != null) {
            try {
                derivedValueProviderImpl = derivedValueAnnotation.service().newInstance();
                derivedValueProviderImpl.init(element, property, derivedValueAnnotation.params());
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
                derivedValueProviderImpl = null;
            }
        }
        return derivedValueProviderImpl;
    }
}

