/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.modeling.ValueProperty;

public final class MemoryResource
extends Resource {
    private static final String[] EMPTY_PARAMS = new String[0];
    private final ModelElementType type;

    public MemoryResource(ModelElementType type) {
        this(type, null);
    }

    public MemoryResource(ModelElementType type, MemoryResource parent) {
        super(parent);
        this.type = type;
    }

    public ModelElementType type() {
        return this.type;
    }

    public MemoryResource parent() {
        return (MemoryResource)super.parent();
    }

    public MemoryResource root() {
        return (MemoryResource)super.root();
    }

    protected BindingImpl createBinding(ModelProperty property) {
        BindingImpl binding = null;
        if (property instanceof ValueProperty) {
            binding = new ValueBindingImpl(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        } else if (property instanceof ImpliedElementProperty) {
            binding = new ElementBindingImpl(property){
                private final MemoryResource element;
                {
                    this.element = new MemoryResource(modelProperty.getType(), MemoryResource.this);
                }

                public ModelElementType type(Resource resource) {
                    return ((MemoryResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }
            };
        } else if (property instanceof ElementProperty) {
            binding = new ElementBindingImpl(){
                private MemoryResource element;

                public ModelElementType type(Resource resource) {
                    return ((MemoryResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }

                public Resource create(ModelElementType type) {
                    this.element = new MemoryResource(type, MemoryResource.this);
                    return this.element;
                }

                public void remove() {
                    this.element = null;
                }

                public boolean removable() {
                    return true;
                }
            };
        } else if (property instanceof ListProperty) {
            binding = new ListBindingImpl(){
                private final List<Resource> list = new ArrayList<Resource>();

                @Override
                public ModelElementType type(Resource resource) {
                    return ((MemoryResource)resource).type();
                }

                @Override
                public List<Resource> read() {
                    return this.list;
                }

                @Override
                public Resource add(ModelElementType type) {
                    MemoryResource resource = new MemoryResource(type, MemoryResource.this);
                    this.list.add(resource);
                    return resource;
                }

                @Override
                public void remove(Resource resource) {
                    this.list.remove(resource);
                }

                @Override
                public void swap(Resource a, Resource b) {
                    int aIndex = this.list.indexOf(a);
                    int bIndex = this.list.indexOf(b);
                    this.list.set(aIndex, b);
                    this.list.set(bIndex, a);
                }
            };
        }
        if (binding != null) {
            binding.init(this.element(), property, EMPTY_PARAMS);
        }
        return binding;
    }
}

