/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesServiceFactory
extends ModelPropertyServiceFactory {
    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return property instanceof ValueProperty && property.hasAnnotation(PossibleValues.class);
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        PossibleValuesService svc = null;
        PossibleValues annotation = property.getAnnotation(PossibleValues.class);
        if (annotation != null) {
            if (!annotation.service().equals(PossibleValuesService.class)) {
                try {
                    svc = annotation.service().newInstance();
                    svc.init(element, property, annotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    svc = null;
                }
            }
            if (svc == null && annotation.values().length > 0) {
                svc = new PossibleValuesServiceStatic(annotation.values(), annotation.invalidValueMessage(), annotation.invalidValueSeverity(), annotation.caseSensitive());
                svc.init(element, property, new String[0]);
            }
            if (svc == null && annotation.property().length() > 0) {
                svc = new PossibleValuesServiceFromModel(new ModelPath(annotation.property()), annotation.invalidValueMessage(), annotation.invalidValueSeverity(), annotation.caseSensitive());
                svc.init(element, property, new String[0]);
            }
        }
        return svc;
    }

    private static abstract class PossibleValuesServiceExt
    extends PossibleValuesService {
        private final String invalidValueMessageTemplate;
        private final int invalidValueSeverity;
        private final boolean caseSensitive;

        public PossibleValuesServiceExt(String invalidValueMessageTemplate, int invalidValueSeverity, boolean caseSensitive) {
            this.invalidValueMessageTemplate = invalidValueMessageTemplate;
            this.invalidValueSeverity = invalidValueSeverity;
            this.caseSensitive = caseSensitive;
        }

        public String getInvalidValueMessage(String invalidValue) {
            return NLS.bind((String)this.invalidValueMessageTemplate, (Object)invalidValue);
        }

        public int getInvalidValueSeverity(String invalidValue) {
            return this.invalidValueSeverity;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PossibleValuesServiceFromModel
    extends PossibleValuesServiceExt {
        private final ModelPath path;
        private Set<String> values;

        public PossibleValuesServiceFromModel(ModelPath path, String invalidValueMessageTemplate, int invalidValueSeverity, boolean caseSensitive) {
            super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
            this.path = path;
            this.values = Collections.emptySet();
        }

        @Override
        public void init(final IModelElement element, ModelProperty property, String[] params) {
            super.init(element, property, params);
            final ModelPropertyListener listener = new ModelPropertyListener(){

                public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                    PossibleValuesServiceFromModel.this.refresh();
                }
            };
            element.addListener(listener, this.path);
            element.addListener(new ModelElementListener(){

                public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                    element.removeListener(listener, PossibleValuesServiceFromModel.this.path);
                }
            });
        }

        @Override
        protected void fillPossibleValues(SortedSet<String> values) {
            values.addAll(this.values);
        }

        private void refresh() {
            SortedSet<String> newValues = this.element().read(this.path);
            if (!this.values.equals(newValues)) {
                this.values = Collections.unmodifiableSet(newValues);
                this.notifyListeners(new PossibleValuesService.PossibleValuesChangedEvent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PossibleValuesServiceStatic
    extends PossibleValuesServiceExt {
        private final List<String> values;

        public PossibleValuesServiceStatic(String[] values, String invalidValueMessageTemplate, int invalidValueSeverity, boolean caseSensitive) {
            super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    list.add(item);
                }
                ++n2;
            }
            this.values = Collections.unmodifiableList(list);
        }

        @Override
        protected void fillPossibleValues(SortedSet<String> values) {
            values.addAll(this.values);
        }
    }
}

