/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementServiceFactory;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireModelingExtensionSystem {
    private static final String EL_VALUE_SERIALIZATION_SERVICE = "value-serialization-service";
    private static final String EL_MODEL_ELEMENT_SERVICE = "model-element-service";
    private static final String EL_MODEL_PROPERTY_SERVICE = "model-property-service";
    private static final String EL_FUNCTION = "function";
    private static final String EL_NAME = "name";
    private static final String EL_TYPE = "type";
    private static final String EL_FACTORY = "factory";
    private static final String EL_IMPL = "impl";
    private static boolean initialized = false;
    private static List<ExtensionHandle> extensionHandles;
    private static List<ModelElementServiceFactory> modelElementServiceFactories;
    private static List<ModelPropertyServiceFactory> modelPropertyServiceFactories;
    private static List<ValueSerializationServiceFactory> valueSerializerFactories;
    private static Map<String, FunctionFactory> functionFactories;

    public static List<ExtensionHandle> getExtensionHandles() {
        SapphireModelingExtensionSystem.initialize();
        return extensionHandles;
    }

    public static ModelElementService createModelElementService(IModelElement element, Class<? extends ModelElementService> service) {
        SapphireModelingExtensionSystem.initialize();
        for (ModelElementServiceFactory factory : modelElementServiceFactories) {
            ModelElementService instance;
            if (!factory.applicable(element, service) || (instance = factory.create(element, service)) == null) continue;
            return instance;
        }
        return null;
    }

    public static ModelPropertyService createModelPropertyService(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        SapphireModelingExtensionSystem.initialize();
        for (ModelPropertyServiceFactory factory : modelPropertyServiceFactories) {
            ModelPropertyService instance;
            if (!factory.applicable(element, property, service) || (instance = factory.create(element, property, service)) == null) continue;
            return instance;
        }
        return null;
    }

    public static ValueSerializationService createValueSerializer(IModelElement element, ValueProperty property, Class<?> type) {
        SapphireModelingExtensionSystem.initialize();
        for (ValueSerializationServiceFactory factory : valueSerializerFactories) {
            ValueSerializationService instance;
            if (!factory.applicable(type) || (instance = factory.create(element, property)) == null) continue;
            return instance;
        }
        return null;
    }

    public static Function createFunction(String name, Function ... operands) {
        SapphireModelingExtensionSystem.initialize();
        FunctionFactory factory = functionFactories.get(name.toLowerCase());
        if (factory != null) {
            return factory.create(operands);
        }
        return null;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            modelElementServiceFactories = new ArrayList<ModelElementServiceFactory>();
            modelPropertyServiceFactories = new ArrayList<ModelPropertyServiceFactory>();
            valueSerializerFactories = new ArrayList<ValueSerializationServiceFactory>();
            functionFactories = new HashMap<String, FunctionFactory>();
            extensionHandles = new ArrayList<ExtensionHandle>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.sapphire.modeling", "extension");
            if (point == null) {
                extensionHandles.add(new ClassLoaderExtensionHandle(SapphireModelingExtensionSystem.class.getClassLoader()));
            } else {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    extensionHandles.add(new BundleExtensionHandle(extension.getContributor().getName()));
                    ++n2;
                }
            }
            for (ExtensionHandle handle : extensionHandles) {
                for (URL url : handle.findExtensionFiles()) {
                    Element root = SapphireModelingExtensionSystem.parse(url);
                    if (root == null) continue;
                    NodeList nodes = root.getChildNodes();
                    int i = 0;
                    int n = nodes.getLength();
                    while (i < n) {
                        Node node = nodes.item(i);
                        if (node instanceof Element) {
                            Element el = (Element)node;
                            String elname = el.getLocalName();
                            try {
                                Class serviceFactory;
                                Class serviceType;
                                if (elname.equals(EL_VALUE_SERIALIZATION_SERVICE)) {
                                    Class valueType = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                    Class serializerClass = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_IMPL)));
                                    valueSerializerFactories.add(new ValueSerializationServiceFactory(valueType, serializerClass));
                                } else if (elname.equals(EL_MODEL_ELEMENT_SERVICE)) {
                                    serviceType = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                    serviceFactory = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_FACTORY)));
                                    modelElementServiceFactories.add(new ModelElementServiceFactoryProxy(serviceType, serviceFactory));
                                } else if (elname.equals(EL_MODEL_PROPERTY_SERVICE)) {
                                    serviceType = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                    serviceFactory = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_FACTORY)));
                                    modelPropertyServiceFactories.add(new ModelPropertyServiceFactoryProxy(serviceType, serviceFactory));
                                } else if (elname.equals(EL_FUNCTION)) {
                                    String name = SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_NAME));
                                    Class impl = handle.loadClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_IMPL)));
                                    functionFactories.put(name.toLowerCase(), new FunctionFactory(impl));
                                }
                            }
                            catch (InvalidExtensionException invalidExtensionException) {}
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private static Element parse(URL url) {
        Element element;
        InputStream in = url.openStream();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = docbuilder.parse(in);
            element = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return element;
    }

    private static Element child(Element element, String name) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Element el;
            Node node = nodes.item(i);
            if (node instanceof Element && name.equals((el = (Element)node).getLocalName())) {
                return el;
            }
            ++i;
        }
        throw new InvalidExtensionException();
    }

    private static String text(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node instanceof Text) {
                buf.append(((Text)node).getData());
            }
            ++i;
        }
        return buf.toString().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BundleExtensionHandle
    extends ExtensionHandle {
        private final Bundle bundle;

        public BundleExtensionHandle(String bundleId) {
            this.bundle = Platform.getBundle((String)bundleId);
        }

        @Override
        public List<URL> findExtensionFiles() {
            ArrayList<URL> files = new ArrayList<URL>();
            if (this.bundle != null) {
                try {
                    Enumeration urls = this.bundle.getResources("META-INF/sapphire-extension.xml");
                    while (urls.hasMoreElements()) {
                        URL url = (URL)urls.nextElement();
                        if (url == null) continue;
                        files.add(url);
                    }
                }
                catch (IOException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
            return files;
        }

        @Override
        public <T> Class<T> loadClass(String className) {
            Class cl = null;
            if (className != null) {
                try {
                    cl = this.bundle.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InvalidExtensionException();
                }
            }
            return cl;
        }

        @Override
        public URL resolveResource(String name) {
            return this.bundle.getResource(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassLoaderExtensionHandle
    extends ExtensionHandle {
        private final ClassLoader classLoader;

        public ClassLoaderExtensionHandle(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public List<URL> findExtensionFiles() {
            ArrayList<URL> files = new ArrayList<URL>();
            try {
                Enumeration<URL> urls = this.classLoader.getResources("META-INF/sapphire-extension.xml");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (url == null) continue;
                    files.add(url);
                }
            }
            catch (IOException e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
            return files;
        }

        @Override
        public <T> Class<T> loadClass(String className) {
            Class<?> cl = null;
            if (className != null) {
                try {
                    cl = this.classLoader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InvalidExtensionException();
                }
            }
            return cl;
        }

        @Override
        public URL resolveResource(String name) {
            return this.classLoader.getResource(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExtensionHandle {
        public abstract List<URL> findExtensionFiles();

        public abstract <T> Class<T> loadClass(String var1);

        public abstract URL resolveResource(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionFactory {
        private final Class<? extends Function> functionClass;
        private boolean functionInstantiationFailed;

        public FunctionFactory(Class<? extends Function> functionClass) {
            this.functionClass = functionClass;
        }

        public Function create(Function ... operands) {
            Function function = null;
            if (!this.functionInstantiationFailed) {
                try {
                    function = this.functionClass.newInstance();
                    function.init(operands);
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    function = null;
                    this.functionInstantiationFailed = true;
                }
            }
            return function;
        }
    }

    public static final class InvalidExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ModelElementServiceFactoryProxy
    extends ModelElementServiceFactory {
        private final Class<? extends ModelElementService> type;
        private final Class<? extends ModelElementServiceFactory> factoryClass;
        private ModelElementServiceFactory factoryInstance;
        private boolean factoryInstantiationFailed;

        public ModelElementServiceFactoryProxy(Class<? extends ModelElementService> type, Class<? extends ModelElementServiceFactory> factoryClass) {
            this.type = type;
            this.factoryClass = factoryClass;
        }

        @Override
        public boolean applicable(IModelElement element, Class<? extends ModelElementService> service) {
            ModelElementServiceFactory factory;
            boolean result = false;
            if (service.isAssignableFrom(this.type) && (factory = this.getFactory()) != null) {
                result = factory.applicable(element, service);
            }
            return result;
        }

        @Override
        public ModelElementService create(IModelElement element, Class<? extends ModelElementService> service) {
            ModelElementService result = null;
            ModelElementServiceFactory factory = this.getFactory();
            if (factory != null) {
                result = factory.create(element, service);
            }
            return result;
        }

        private synchronized ModelElementServiceFactory getFactory() {
            if (this.factoryInstance == null && !this.factoryInstantiationFailed) {
                try {
                    this.factoryInstance = this.factoryClass.newInstance();
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    this.factoryInstantiationFailed = true;
                }
            }
            return this.factoryInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ModelPropertyServiceFactoryProxy
    extends ModelPropertyServiceFactory {
        private final Class<? extends ModelPropertyService> type;
        private final Class<? extends ModelPropertyServiceFactory> factoryClass;
        private ModelPropertyServiceFactory factoryInstance;
        private boolean factoryInstantiationFailed;

        public ModelPropertyServiceFactoryProxy(Class<? extends ModelPropertyService> type, Class<? extends ModelPropertyServiceFactory> factoryClass) {
            this.type = type;
            this.factoryClass = factoryClass;
        }

        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            ModelPropertyServiceFactory factory;
            boolean result = false;
            if (service.isAssignableFrom(this.type) && (factory = this.getFactory()) != null) {
                result = factory.applicable(element, property, service);
            }
            return result;
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            ModelPropertyService result = null;
            ModelPropertyServiceFactory factory = this.getFactory();
            if (factory != null) {
                result = factory.create(element, property, service);
            }
            return result;
        }

        private synchronized ModelPropertyServiceFactory getFactory() {
            if (this.factoryInstance == null && !this.factoryInstantiationFailed) {
                try {
                    this.factoryInstance = this.factoryClass.newInstance();
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    this.factoryInstantiationFailed = true;
                }
            }
            return this.factoryInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueSerializationServiceFactory {
        private final Class<?> type;
        private final Class<? extends ValueSerializationService> serializerClass;
        private boolean serializerInstantiationFailed;

        public ValueSerializationServiceFactory(Class<?> type, Class<? extends ValueSerializationService> serializerClass) {
            this.type = type;
            this.serializerClass = serializerClass;
        }

        public boolean applicable(Class<?> type) {
            boolean result = false;
            if (this.type.isAssignableFrom(type)) {
                result = true;
            }
            return result;
        }

        public ValueSerializationService create(IModelElement element, ValueProperty property) {
            ValueSerializationService serializer = null;
            if (!this.serializerInstantiationFailed) {
                try {
                    serializer = this.serializerClass.newInstance();
                    serializer.init(element, property, new String[0]);
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    serializer = null;
                    this.serializerInstantiationFailed = true;
                }
            }
            return serializer;
        }
    }
}

