/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.java.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.java.JavaPackageName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedJavaIdentifierValueValidator
extends ModelPropertyValidator<Value<JavaPackageName>> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatus validate(Value<JavaPackageName> value) {
        String val = value.getText(false);
        boolean valid = true;
        if (val != null) {
            int state = 1;
            int i = 0;
            int n = val.length();
            while (i < n) {
                block10: {
                    char ch = val.charAt(i);
                    if (state == 1) {
                        if (Character.isJavaIdentifierStart(ch)) {
                            state = 2;
                            break block10;
                        } else {
                            valid = false;
                            break;
                        }
                    }
                    if (ch == '.') {
                        state = 1;
                    } else if (!Character.isJavaIdentifierPart(ch)) {
                        valid = false;
                        break;
                    }
                }
                ++i;
            }
            if (state == 1) {
                valid = false;
            }
        }
        if (valid) {
            return Status.OK_STATUS;
        }
        String msg = NLS.bind((String)Resources.invalidQualifiedJavaIdentifierMessage, (Object)val);
        return this.createErrorStatus(msg);
    }

    private static final class Resources
    extends NLS {
        public static String invalidQualifiedJavaIdentifierMessage;

        static {
            Resources.initializeMessages((String)QualifiedJavaIdentifierValueValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

