/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.localization;

import java.security.MessageDigest;

public final class LocalizationUtil {
    private LocalizationUtil() {
    }

    public static String transformCamelCaseToLabel(String value) {
        StringBuilder label = new StringBuilder();
        int i = 0;
        int n = value.length();
        while (i < n) {
            char ch = value.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (label.length() > 0) {
                    label.append(' ');
                }
                label.append(Character.toLowerCase(ch));
            } else {
                label.append(ch);
            }
            ++i;
        }
        return label.toString();
    }

    public static final String createStringDigest(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] input = str.getBytes("UTF-8");
            byte[] digest = md.digest(input);
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    buf.append('0');
                }
                buf.append(hex);
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

