/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.localization;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardLocalizationService
extends LocalizationService {
    private static final Locale NULL_LOCALE = new Locale("");
    private final Locale locale;
    private Map<String, String> sourceLangToTranslation;

    public StandardLocalizationService(Locale locale) {
        this.locale = locale;
    }

    protected final synchronized void init() {
        if (this.sourceLangToTranslation == null) {
            Map<String, String> keyToSource = this.load(NULL_LOCALE);
            Map<String, String> keyToTranslation = this.load(this.locale);
            this.sourceLangToTranslation = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : keyToSource.entrySet()) {
                String key = entry.getKey();
                String source = entry.getValue();
                String translation = keyToTranslation.get(key);
                if (translation == null || source.equals(translation)) continue;
                this.sourceLangToTranslation.put(source, translation);
            }
        }
    }

    protected final Map<String, String> load(Locale locale) {
        Locale l = locale;
        HashMap<String, String> keyToTranslation = new HashMap<String, String>();
        if (this.load(l, keyToTranslation)) {
            return keyToTranslation;
        }
        String variant = l.getVariant();
        if (variant != null && variant.length() > 0 && this.load(l = new Locale(l.getLanguage(), l.getCountry()), keyToTranslation)) {
            return keyToTranslation;
        }
        String country = l.getCountry();
        if (country != null && country.length() > 0 && this.load(l = new Locale(l.getLanguage()), keyToTranslation)) {
            return keyToTranslation;
        }
        String language = l.getLanguage();
        if (language != null && language.length() > 0) {
            this.load(NULL_LOCALE, keyToTranslation);
        }
        return keyToTranslation;
    }

    protected abstract boolean load(Locale var1, Map<String, String> var2);

    protected static final boolean parse(InputStream in, Map<String, String> keyToText) {
        Properties props = new Properties();
        try {
            try {
                props.load(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            keyToText.put((String)entry.getKey(), (String)entry.getValue());
        }
        return true;
    }

    @Override
    public String text(String sourceLangString, CapitalizationType capitalizationType, boolean includeMnemonic) {
        this.init();
        String result = this.sourceLangToTranslation.get(sourceLangString);
        if (result == null) {
            result = sourceLangString;
        }
        result = this.transform(result, capitalizationType, includeMnemonic);
        return result;
    }
}

