/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import org.eclipse.sapphire.modeling.docsys.BoldPart;
import org.eclipse.sapphire.modeling.docsys.DocumentationContent;
import org.eclipse.sapphire.modeling.docsys.DocumentationPart;
import org.eclipse.sapphire.modeling.docsys.LineBreakPart;
import org.eclipse.sapphire.modeling.docsys.ListItem;
import org.eclipse.sapphire.modeling.docsys.ListPart;
import org.eclipse.sapphire.modeling.docsys.OrderedListPart;
import org.eclipse.sapphire.modeling.docsys.ParagraphBreakPart;
import org.eclipse.sapphire.modeling.docsys.TextPart;
import org.eclipse.sapphire.modeling.docsys.UnorderedListPart;

public class DocumentationUtil {
    public static final String NEW_LINE = "\r\n";
    public static final String NEW_LINE_2 = "\r\n\r\n";

    public static final String collapseString(String str) {
        String text = str.trim();
        StringBuilder buf = new StringBuilder();
        boolean skipNextWhitespace = true;
        int i = 0;
        int n = text.length();
        while (i < n) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!skipNextWhitespace) {
                    buf.append(' ');
                    skipNextWhitespace = true;
                }
            } else {
                buf.append(ch);
                skipNextWhitespace = false;
            }
            ++i;
        }
        int length = buf.length();
        if (length > 0 && buf.charAt(length - 1) == ' ') {
            buf.deleteCharAt(length - 1);
        }
        return buf.toString();
    }

    public static final String decodeDocumentationTags(String str) {
        if (str == null) {
            return str;
        }
        String text = DocumentationUtil.collapseString(str);
        DocumentationContent content = DocumentationContent.parse(text);
        StringBuilder buf = new StringBuilder();
        DocumentationUtil.format(buf, content, -1);
        return buf.toString();
    }

    private static void format(StringBuilder buf, DocumentationPart part, int index) {
        block7: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        if (!(part instanceof TextPart)) break block6;
                                        buf.append(((TextPart)part).getText());
                                        break block7;
                                    }
                                    if (!(part instanceof LineBreakPart)) break block8;
                                    buf.append(NEW_LINE);
                                    break block7;
                                }
                                if (!(part instanceof ParagraphBreakPart)) break block9;
                                buf.append(NEW_LINE_2);
                                break block7;
                            }
                            if (!(part instanceof OrderedListPart)) break block10;
                            buf.append(NEW_LINE_2);
                            int childIndex = 0;
                            for (ListItem item : ((ListPart)part).getItems()) {
                                DocumentationUtil.format(buf, item, ++childIndex);
                            }
                            break block7;
                        }
                        if (!(part instanceof UnorderedListPart)) break block11;
                        buf.append(NEW_LINE_2);
                        for (ListItem item : ((ListPart)part).getItems()) {
                            DocumentationUtil.format(buf, item, -1);
                        }
                        break block7;
                    }
                    if (!(part instanceof ListItem)) break block12;
                    buf.append(index == -1 ? "*" : Integer.valueOf(index));
                    buf.append("  ");
                    for (DocumentationPart child : ((ListItem)part).getChildren()) {
                        DocumentationUtil.format(buf, child, -1);
                    }
                    buf.append(NEW_LINE);
                    break block7;
                }
                if (!(part instanceof BoldPart)) break block13;
                BoldPart boldPart = (BoldPart)part;
                if (boldPart.isOpen()) {
                    buf.append("<@#$b>");
                } else {
                    buf.append("</@#$b>");
                }
                break block7;
            }
            if (!(part instanceof DocumentationContent)) break block7;
            for (DocumentationPart child : ((DocumentationContent)part).getChildren()) {
                DocumentationUtil.format(buf, child, -1);
            }
        }
    }
}

