/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

public final class FileUtil {
    public static IFile getWorkspaceFile(File f) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IFile[] wsFiles = wsroot.findFilesForLocationURI(f.toURI());
        if (wsFiles.length > 0) {
            return wsFiles[0];
        }
        return null;
    }

    public static IContainer getWorkspaceContainer(File f) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IContainer[] wsContainers = wsroot.findContainersForLocationURI(f.toURI());
        if (wsContainers.length > 0) {
            return wsContainers[0];
        }
        return null;
    }

    public static void mkdirs(File f) throws CoreException {
        IContainer wsContainer = FileUtil.getWorkspaceContainer(f);
        if (f.exists()) {
            if (f.isFile()) {
                String msg = NLS.bind((String)Resources.locationIsFile, (Object)f.getAbsolutePath());
                throw new CoreException(SapphireModelingFrameworkPlugin.createErrorStatus(msg));
            }
            if (wsContainer != null) {
                wsContainer.refreshLocal(0, null);
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            if (wsContainer != null) {
                IFolder iFolder = (IFolder)wsContainer;
                iFolder.create(true, true, null);
            } else {
                boolean isSuccessful = f.mkdir();
                if (!isSuccessful) {
                    String msg = NLS.bind((String)Resources.failedToCreateDirectory, (Object)f.getAbsolutePath());
                    throw new CoreException(SapphireModelingFrameworkPlugin.createErrorStatus(msg));
                }
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String failedToCreateDirectory;
        public static String locationIsFile;

        static {
            Resources.initializeMessages((String)FileUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

