/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.validators.PathValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbsolutePathValueValidator
extends PathValueValidator {
    public AbsolutePathValueValidator(ValueProperty property) {
        super(property);
    }

    @Override
    public IStatus validate(Value<IPath> value) {
        IPath path = value.getContent(false);
        if (path != null) {
            File f = path.toFile();
            if (f.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (f.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.pathIsNotFile, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !f.isDirectory()) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.pathIsNotFolder, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
            } else if (this.resourceMustExist) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.fileMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.folderMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.resourceMustExist, (Object)path.toString());
                return new Status(4, "org.eclipse.sapphire.modeling", message);
            }
        }
        return Status.OK_STATUS;
    }
}

