/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.validators.PathValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseWorkspacePathValueValidator
extends PathValueValidator {
    public EclipseWorkspacePathValueValidator(ValueProperty property) {
        super(property);
    }

    @Override
    public IStatus validate(Value<IPath> value) {
        IPath path = value.getContent(false);
        if (path != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (resource.getType() == 1) {
                        return this.validateExtensions(path);
                    }
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.pathIsNotFile, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && resource.getType() != 2 && resource.getType() != 4) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.pathIsNotFolder, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
            } else if (this.resourceMustExist) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.fileMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.folderMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                String message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.resourceMustExist, (Object)path.toString());
                return new Status(4, "org.eclipse.sapphire.modeling", message);
            }
        }
        return Status.OK_STATUS;
    }
}

