/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressValidator
extends ModelPropertyValidator<Value<?>> {
    @Override
    public IStatus validate(Value<?> value) {
        String address = value.getText();
        if (address != null && !address.equals("")) {
            int j = 0;
            while (j < 4) {
                int index = address.indexOf(".");
                if (index == -1 && j < 3) {
                    String label = value.getProperty().getLabel(true, CapitalizationType.NO_CAPS, false);
                    return this.createErrorStatus(Resources.bind((String)Resources.ipAddressError, (Object)value.getText(), (Object)label));
                }
                if (j == 3) {
                    index = address.length();
                }
                int i = 0;
                while (i < index) {
                    if (!Character.isDigit(address.charAt(i))) {
                        String label = value.getProperty().getLabel(true, CapitalizationType.NO_CAPS, false);
                        return this.createErrorStatus(Resources.bind((String)Resources.ipAddressError, (Object)value.getText(), (Object)label));
                    }
                    ++i;
                }
                if (j < 3) {
                    address = address.substring(index + 1);
                }
                ++j;
            }
        }
        return Status.OK_STATUS;
    }

    private static final class Resources
    extends NLS {
        public static String ipAddressError;

        static {
            Resources.initializeMessages((String)IPAddressValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

